﻿// #region PP.GoogleMapPlugin
(function ()
{
	var isDefined = false;

	function definePluginClass(settings)
	{
		if (isDefined)
			return;

		PP.GoogleMapPlugin = function (settings)
		{
			PP.extend(settings, this._ExternalSettings, true, true);
			PP.GoogleMapPlugin.base.constructor.call(this, settings);

			//ассоциативный массив полигонов полученных из топоосновы, хранящихся по идентификатору шейпа карты. 
			//Полигоны хранятся как массив объетов гугл-карты в формате { <shapeId>: [ <google.maps.Polygon | google.maps.Polyline>, <...> ], ... }	
			this._gPolygons = {};
			//Кэш вычисленных границ шейпов. Границы шейпов необходимы при отрисовке разнообразной графики поверх карты. (Стрелки, маркеры, диаграммки и т.п.)
			this._shapeBoundsCache = {};

			//Хэш-таблица перевода атрибутов шэйпов PP.Ui.Map в атрибуты гугл-полигонов
			this._attrsMap = {
				'stroke': 'strokeColor',
				'stroke-opacity': 'strokeOpacity',
				'stroke-width': 'strokeWeight',
				'z-index': 'zIndex'
			};
		};

		PP.initClass(PP.GoogleMapPlugin, PP.ExternalMapPlugin, 'PP.GoogleMapPlugin');

		var gmp = PP.GoogleMapPlugin.prototype;

		gmp._APIKey = null; //Ключ API Google Maps
		gmp._APILibraries = []; //Библиотеки Google Maps API, которые необходимо загрузить. Массив со строками, представляющими названия библиотек https://developers.google.com/maps/documentation/javascript/libraries
		gmp._Language = null; //Локаль, с которой будет загружен Google Maps API, если не указана, используется либо текущая локаль PP, либо автоматическое определение локали исходя из местоположения и настроек браузера в зависимости от параметра UsePPLocale.
		gmp._UsePPLocale = true; //Использовать локаль PP в случае если она не указана явно в параметре Language. Если параметр равен false, используется автоматическое определение локали исходя из местоположения и настроек браузера
		gmp._Background = null; //Цвет фона
		gmp._ExternalSettings = settings;

		gmp._initExternalAPI = function ()
		{
			var gmapsUrl = 'https://maps.googleapis.com/maps/api/js';
			var urlParams = []; //параметры запроса

			if (this._APIKey)
				urlParams.push('key=' + this._APIKey);
			if (this._APILibraries.length)
				urlParams.push('libraries=' + this._APILibraries.join(','));
			if (this._Language)
				urlParams.push('language=' + this._Language);
			else if (this._UsePPLocale)
				urlParams.push('language=' + PP.getCurrentCulture().CultureName);

			if (urlParams.length)
				gmapsUrl += ('?' + urlParams.join('&'));

			if (!PP.ScriptManager.loadScript(gmapsUrl, this._onGoogleMapsApiLoaded.bind(this), null, 'googleApiGeo'))
				this._onGoogleMapsApiLoaded();
		};

		gmp._onGoogleMapsApiLoaded = function ()
		{
			this._apiReady = true;
		};

		gmp._createMap = function ()
		{
			if (!this._gMap)
			{
				var center = this._getCenter();

				this._gMap = new google.maps.Map(this._mapNode, {
					'center': new google.maps.LatLng(center[0], center[1]),
					'zoom': 2,
					'minZoom': 2,
					'mapTypeId': google.maps.MapTypeId.ROADMAP,
					'mapTypeControl': false,
					'streetViewControl': false,
					'backgroundColor': this._Background ? this._Background.getColor() : null
				});

				this._canvasOverlay = this._createOverlay();
				this._svgOverlay = this._createOverlay(true);

				google.maps.event.addListenerOnce(this._gMap, 'idle', this._onIdleGoogleMap.bind(this));
			} else
			{
				for (var shapeId in this._gPolygons)
				{
					this._gPolygons[shapeId].forEach(function (polygon)
					{
						polygon.unbindAll();
						polygon.setMap(null);
					});
				}
				this._gPolygons = {};
				this._shapeBoundsCache = {};

				this._isReady = true;
				this.Ready.fire(this);
			}
		};

		gmp._createOverlay = function (svgOnly)
		{
			var result = new google.maps.OverlayView();
			result.googleMapPlugin = this;
			result.width = this._Width;
			result.height = this._Height;
			if (!svgOnly)
				result.node = new PP.Ui.Canvas();
			else
			{
				result.node = PP.SVG.svg();
				PP.SVG.group(result.node);
				result.node.style.position = 'absolute';
			}

			result.onAdd = function ()
			{
				if (this.node instanceof PP.Ui.Canvas)
					this.node.addToNode(this.getPanes().overlayImage);
				else
					this.getPanes().overlayImage.appendChild(this.node);
				this.draw();
			};

			result.setSize = function (width, height)
			{
				this.width = width;
				this.height = height;
				this.draw();
			};

			result.draw = function ()
			{
				var projection = this.getProjection();
				if (projection)
				{
					var centerPoint = projection.fromLatLngToDivPixel(this.map.getCenter());
					if (this.node instanceof PP.Ui.Canvas)
						this.node.setBounds(centerPoint.x - this.width / 2, centerPoint.y - this.height / 2, this.width, this.height);
					else
					{
						this.node.style.left = (centerPoint.x - this.width / 2) + "px";
						this.node.style.top = (centerPoint.y - this.height / 2) + "px";
						this.node.style.width = this.width + 'px';
						this.node.style.height = this.height + 'px';
					}
				}
			};

			result.remove = function ()
			{
				if (this.node instanceof PP.Ui.Canvas)
					this.node.removeFromDOM();
				else if (this.node.parentNode)
					this.node.parentNode.removeChild(this.node);
			};

			result.setMap(this._gMap);

			return result;
		};

		gmp._deleteOverlay = function (overlay)
		{
			overlay.setMap(null);
			if (overlay.node.dispose)
				overlay.node.dispose();
			return null;
		};

		gmp._onIdleGoogleMap = function ()
		{
			if (this.isLive())
			{
				this._isReady = true;
				this.Ready.fire(this);

				google.maps.event.trigger(this._gMap, 'resize');
				if (this._boundsPoints)
				{
					var minPoint = new google.maps.LatLng(this._boundsPoints.min.y, this._boundsPoints.min.x),
						maxPoint = new google.maps.LatLng(this._boundsPoints.max.y, this._boundsPoints.max.x);
					this._boundsObject = new google.maps.LatLngBounds(minPoint, maxPoint);
					this._gMap.fitBounds(this._boundsObject);
				}

				google.maps.event.addListener(this._gMap, 'bounds_changed', this._refreshOverlays.bind(this));
			}
		};

		gmp._refreshOverlays = function ()
		{
			if (this._updateOverlaysTimeout)
			{
				clearTimeout(this._updateOverlaysTimeout);
				this._updateOverlaysTimeout = null;
			}

			this._updateOverlaysTimeout = setTimeout(function ()
			{
				if (this.isReady())
				{
					this._canvasOverlay.draw();
					this.Refreshed.fire(this);
				}
			}.bind(this), 25);
		};

		gmp.setSize = function (width, height)
		{
			PP.GoogleMapPlugin.base.setSize.apply(this, arguments);

			if (this._gMap)
			{
				this._canvasOverlay.setSize(this._Width, this._Height);
				this._svgOverlay.setSize(this._Width, this._Height);
				google.maps.event.trigger(this._gMap, 'resize');
				if (this._boundsObject)
					this._gMap.setOptions({ minZoom: 0 });
			}

		};

		gmp.hide = function ()
		{
			if (google && google.maps && google.maps.event && this._gMap)
			{
				try
				{
					google.maps.event.removeListener(this._gMap);
				} catch (e) { }
			}
			PP.GoogleMapPlugin.base.hide.apply(this, arguments);
		};

		gmp.drawShape = function (shape, isVisible, isStroked, isGradient, color, opacity, borderColor, borderWidth)
		{
			if (!shape || !shape.isLive())
				return;

			var shapeId = shape.getId(),
				data = shape.getPluginData();

			if (!this._gPolygons[shapeId])
			{
				if (!isVisible)
					return;

				this._gPolygons[shapeId] = [];
				for (var i = 0; i < data.polygons.length; i++)
				{
					//1. Создаем объекты типа LatLng из набора точек полигона
					var path = data.polygons[i].map(function (latlng) { return new google.maps.LatLng(latlng[0], latlng[1]); }),
						polygon = null;

					//2. Создаем полигон
					polygon = new google.maps.Polygon({
						map: this._gMap,
						paths: path,
						fillOpacity: isStroked ? 0 : 0.85 * opacity,
						fillColor: color,
						clickable: isStroked ? false : true,
						strokeColor: borderColor,
						strokeWeight: isStroked ? borderWidth : 0,
						zIndex: data.zIndex
					});

					this._gPolygons[shapeId].push(polygon);
					// не нашел, где выдрать значение свойства курсора карты, поэтому вставил тупо ссылку.
					polygon.set('cursor', 'url(http://maps.gstatic.com/mapfiles/openhand_8_8.cur), default;');
					this._bindPolygonEventsListeners(polygon, shape);
				}
			} else
			{
				var attr = {
					fillColor: color,
					fillOpacity: isStroked ? 0 : 0.85 * opacity,
					clickable: isStroked ? false : true,
					strokeColor: borderColor,
					strokeWeight: isStroked && borderColor ? borderWidth : 0
				};

				for (var j = 0; j < this._gPolygons[shapeId].length; j++)
				{
					if (isVisible)
						this._gPolygons[shapeId][j].setOptions(attr);
					else
					{
						this._gPolygons[shapeId][j].unbindAll();
						this._gPolygons[shapeId][j].setMap(null);
					}
				}

				if (!isVisible)
				{
					delete this._gPolygons[shapeId];
					delete this._shapeBoundsCache[shapeId];
				}
			}
		};

		gmp._bindPolygonEventsListeners = function (polygon, shape)
		{
			google.maps.event.addListener(polygon, 'mouseover', this._onPolygonMouseOver.bind(this, shape));
			google.maps.event.addListener(polygon, 'mousemove', this._onPolygonMouseMove.bind(this, shape));
			google.maps.event.addListener(polygon, 'mouseout', this._onPolygonMouseOut.bind(this, shape));
			google.maps.event.addListener(polygon, 'click', this._onPolygonMouseClick.bind(this, shape));
			google.maps.event.addListener(polygon, 'rightclick', this._onPolygonMouseClick.bind(this, shape));
		};

		gmp._getDomEvent = function (gEvent)
		{
			if (gEvent && !(gEvent instanceof MouseEvent))
				for (var i in gEvent)
					if (gEvent[i] instanceof MouseEvent)
					{
						gEvent = gEvent[i];
						break;
					}
			return gEvent;
		};

		gmp._onPolygonMouseOver = function (shape, gEvent)
		{
			this.ShapeMouseOver.fire(this, { Shape: shape, Event: this._getDomEvent(gEvent) });
		};

		gmp._onPolygonMouseMove = function (shape, gEvent)
		{
			this.ShapeMouseMove.fire(this, { Shape: shape, Event: this._getDomEvent(gEvent) });
		};

		gmp._onPolygonMouseOut = function (shape, gEvent)
		{
			this.ShapeMouseOut.fire(this, { Shape: shape, Event: this._getDomEvent(gEvent) });
		};

		gmp._onPolygonMouseClick = function (shape, gEvent)
		{
			this.ShapeClick.fire(this, { Shape: shape, Event: this._getDomEvent(gEvent) });
		};

		gmp.getShapeAttributes = function (shape, attributes)
		{
			/// <summary> Метод получения произвольных атрибутов шейпа. Имена атрибутов как в свг. </summary>
			/// <param name="shape" type="PP.Ui.MapShape"> Шейп. </param>
			/// <param name="attributes" type="String[]"> Массив имен атрибутов. </param>
			/// <returns type="Object"> Ассоциативный массив значений. </returns>

			var res = {};

			if (!shape || !shape.isLive())
				return res;

			var shapeId = shape.getId(),
				fPolygon = this._gPolygons[shapeId] ? this._gPolygons[shapeId][0] : null;

			if (fPolygon)
			{
				for (var i = 0; i < attributes.length; i++)
					res[attributes[i]] = fPolygon[this._attrsMap[attributes[i]] || attributes[i]];
			}

			return res;
		};

		gmp.setShapeAttributes = function (shape, attributes)
		{
			/// <summary> Метод установки произвольных атрибутов шейпа. Имена атрибутов как в свг. </summary>
			/// <param name="shape" type="PP.Ui.MapShape"> Шейп. </param>
			/// <param name="attributes" type="Object"> Ассоциативный массив атрибутов. </param>

			if (!shape || !shape.isLive())
				return;

			var shapeId = shape.getId(),
				polygons = this._gPolygons[shapeId];

			if (polygons)
			{
				var options = {},
					i;

				for (i in attributes)
					options[this._attrsMap[i] || i] = attributes[i];
				for (i = 0; i < polygons.length; i++)
					polygons[i].setOptions(options);
			}
		};

		gmp.getShapeBoundsRect = function (shape)
		{
			/// <summary> Метод получения границ шейпа. </summary>
			/// <returns type="PP.Rect"> Границы. </returns>

			var shapeId = shape && shape.isLive() ? shape.getId() : null,
				gBound = null;

			if (shapeId != null)
			{
				if (this._shapeBoundsCache[shapeId])
					gBound = this._shapeBoundsCache[shapeId];
				else if (this._gPolygons[shapeId])
				{
					gBound = new google.maps.LatLngBounds();
					this._gPolygons[shapeId].forEach(function (polygon)
					{
						var paths = polygon.getPaths();
						if (paths)
						{
							for (var i = 0; i < paths.getLength() ; i++)
							{
								var path = paths.getAt(i);
								for (var j = 0; j < path.getLength() ; j++)
									gBound.extend(path.getAt(j));
							}
						}
					});

					this._shapeBoundsCache[shapeId] = gBound;
				}
			}

			return new PP.Rect({
				Left: gBound ? gBound.getCenter().lng() : 0,
				Top: gBound ? gBound.getCenter().lat() : 0,
				Width: 0,
				Height: 0
			});
		};

		gmp.geoToScreen = function (lng, lat)
		{
			/// <summary> Метод преобразования географических координат в экранные координаты. </summary>
			/// <param name="lng" type="Number"> Долгота. </param>
			/// <param name="lat" type="Number"> Широта. </param>
			/// <returns type="PP.Point"> </returns>
			var projection = this._canvasOverlay.getProjection();

			if (projection)
			{
				var point = projection.fromLatLngToContainerPixel(new google.maps.LatLng(lat, lng));
				return new PP.Point(point.x, point.y);
			}

			return null;
		};

		gmp.getArrowLayer = gmp.getMilestoneLayer = function ()
		{
			return this._svgOverlay && this._svgOverlay.node.firstElementChild;
		};

		gmp.getBarLayer = gmp.getPieLayer = gmp.getBubbleLayer = gmp.getMarkerLayer = function ()
		{
			return this._canvasOverlay && ((this._canvasOverlay.node instanceof PP.Ui.Canvas) ? this._canvasOverlay.node : this._canvasOverlay.node.firstElementChild);
		};

		gmp._disposeOverlays = function ()
		{
			[this._canvasOverlay, this._svgOverlay].forEach(function (overlay)
			{
				overlay.setMap(null);
				if (overlay.node.dispose)
					overlay.node.dispose();
			});

			delete this._canvasOverlay;
			delete this._svgOverlay;
		};

		gmp.dispose = function ()
		{
			if (this._gMap)
			{
				this._gMap.unbindAll();
				clearTimeout(this._updateOverlaysTimeout);
				this._disposeOverlays();
			}

			PP.GoogleMapPlugin.base.dispose.apply(this, arguments);
		};

		gmp = null;
		isDefined = true;
	}

	PP.Google = function (settings)
	{
		PP.Google.base.constructor.apply(this, arguments);
		this._Interfaces = [PP.IMapPlugin];
	};
	PP.initClass(PP.Google, PP.Object, 'PP.Google', [PP.IPlugin]);
	PP.Object.defineProps(PP.Google, ['Interfaces'], false);

	PP.Google.prototype._onReady = function (sender, args)
	{
		if (this._resolve)
			this._resolve();
		definePluginClass(args.Args);
		this._resolve = null;
	};

	PP.Google.prototype.getInstance = function ()
	{
		return { 'ResourceKey': 'eGoogle', 'PPType': 'PP.GoogleMapPlugin', 'TopobaseType': 'Google', 'ServiceTopobaseType': 'Google' };
	};

	PP.Google.prototype.ready = function (resolve, reject)
	{
		if (PP.ExternalMapPlugin)
			return true;
		this._resolve = resolve;
		return false;
	};

	PP.Google.init = function (settings)
	{
		if (PP.ExternalMapPlugin || !PP.ScriptManager.loadScript('ExternalMapPlugin.js', PP.Delegate(this._onReady, this, settings)))
			definePluginClass(settings);
		return new PP.Google;
	};
})();

// #endregion