create table B_CAC (
    OBJ                  INT                            not null,
    CAC                  INT                            not null,
    VALS                 VARCHAR(32) ,
    STAMP                TIMESTAMP                      not null,
    BIN                  lo,
    constraint PK_B_CAC primary key (OBJ, CAC)
);

create index IDX_COBJ_HSH on B_CAC(
   OBJ,
   VALS
); 

create table B_CDAT (
    OBJ                  INT                            not null,
    CAC                  INT                            not null,
    BIN                  lo,
    constraint PK_B_CDAT primary key (OBJ, CAC)
);

create table B_CIO (
    OBJ                  INT                            not null,
    SES                  INT                            not null,
    US_NAM               VARCHAR(127)          not null,
    US_STA               VARCHAR(255)          not null,
    STAMP                TIMESTAMP                      not null,
    CMNT                 VARCHAR(255) ,
    constraint PK_B_CIO primary key (OBJ, SES)
);

alter table B_CIO
   add constraint AK_US_B_CIO unique (OBJ, US_NAM, US_STA);

create table B_DAT (
    OBJ                  INT                            not null,
    BIN                  lo,
    constraint PK_B_DAT primary key (OBJ)
);

create table B_DEP (
    OBJ                  INT                            not null,
    REF                  INT                            not null,
    constraint PK_B_DEP primary key (OBJ, REF)
);

create table B_DU (
    NAMESESSION          VARCHAR(127)          not null,
    STAMP                TIMESTAMP                      not null,
    constraint PK_B_DU primary key (NAMESESSION)
);

create table B_HDAT (
    OBJ                  INT                            not null,
    HIS                  INT                            not null,
    BIN                  lo,
    constraint PK_B_HDAT primary key (OBJ, HIS)
);

create table B_HMOD (
    OBJ                  INT                            not null,
    HIS                  INT                            not null,
    MODK                 INT                            not null,
    STAMP                TIMESTAMP                      not null,
    VERS                 VARCHAR(127)          not null,
    BIN                  lo,
    constraint PK_B_HMOD primary key (OBJ, HIS, MODK)
);

create table B_HOBJ (
    OBJ                  INT                            not null,
    HIS                  INT                            not null,
    ID                   VARCHAR(127)          not null,
    NAM                  VARCHAR(255)          not null,
    DES                  VARCHAR(255) ,
    PAR                  INT,
    SD                   INT,
    STAMP                TIMESTAMP                      not null,
    APP                  INT                            not null,
    CLS                  INT                            not null,
    SHC                  NUMERIC(1,0)                   not null,
    ITL                  NUMERIC(1,0)                   not null,
    LIN                  NUMERIC(1,0)                   not null,
    US_NAM               VARCHAR(127)          not null,
    US_STA               VARCHAR(255)          not null,
    CMNT                 VARCHAR(255) ,
    constraint PK_B_HOBJ primary key (OBJ, HIS)
);

create table B_HPAR (
    OBJ                  INT                            not null,
    HIS                  INT                            not null,
    BIN                  lo,
    constraint PK_B_HPAR primary key (OBJ, HIS)
);

create table B_JAU (
    SES                  INT                            not null,
    STAMP                TIMESTAMP                      not null,
    OP_KEY               INT                            not null,
    OP_POS               INT                            not null,
    OP_LVL               INT                            not null,
    OP_NAM               VARCHAR(127)          not null,
    OP_MSK               INT                            not null
       default -1,
    OP_SUC               NUMERIC(1,0)                   not null,
    OBJ_KEY              INT                            not null,
    OBJ_ID               VARCHAR(127)          not null,
    OBJ_NAM              VARCHAR(255)          not null,
    OBJ_CLS              INT                            not null,
    CMNT                 VARCHAR(2000) ,
    OCL                  NUMERIC(2,0)
);

create index PK_B_JAU on B_JAU(SES);

create table B_JLO (
    SES                  INT                            not null,
    STAMP                TIMESTAMP                      not null,
    STAMP_OUT            TIMESTAMP                      not null,
    US_SID               VARCHAR(127)          not null,
    US_NAM               VARCHAR(127)          not null,
    US_DES               VARCHAR(255) ,
    US_STA               VARCHAR(127)          not null,
    US_OS                VARCHAR(127)          not null,
    US_IP                VARCHAR(127) ,
    ALLO                 NUMERIC(1,0)                   not null,
    CMNT                 VARCHAR(2000) ,
    CMNT_OUT             VARCHAR(2000) 
);

create index PK_B_JLO on B_JLO(SES);

create index B_IX_JLO2US_STA on B_JLO (
   US_STA
) ;

create table B_LAST (
    LAS                  INT                            not null
       default 0,
    VER                  INT                            not null,
    constraint PK_B_LAST primary key (LAS)
);

create table B_LCL (
    LCL                  INT                            not null,
    DFL                  NUMERIC(1,0)                   not null,
    constraint PK_B_LCL primary key (LCL)
);

create table B_MOD (
    OBJ                  INT                            not null,
    MODK                 INT                            not null,
    STAMP                TIMESTAMP                      not null,
    VERS                 VARCHAR(127)          not null
       default '0',
    BIN                  lo,
    constraint PK_B_MOD primary key (OBJ, MODK)
);

create table B_NAM (
    OBJ                  INT                            not null,
    LCL                  INT                            not null,
    NAM                  VARCHAR(255) ,
    DES                  VARCHAR(255) ,
    constraint PK_B_NAM primary key (OBJ, LCL)
);

create index IDX_NAM_LCL on B_NAM(
   LCL
); 

create table B_OBJ (
    OBJ                  INT                            not null,
    ID                   VARCHAR(127)          not null,
    ONS                  INT                            not null,
    NAM                  VARCHAR(255)          not null,
    DES                  VARCHAR(255) ,
    PAR                  INT,
    SD                   INT,
    STAMP                TIMESTAMP                      not null,
    APP                  INT                            not null,
    CLS                  INT                            not null,
    LCK                  NUMERIC(1,0)                   not null,
    SHC                  NUMERIC(1,0)                   not null,
    ITL                  NUMERIC(1,0)                   not null,
    LIN                  NUMERIC(1,0)                   not null,
    DEF                  NUMERIC(1,0)                   not null
       default 0,
    TRACK_DEP            NUMERIC(1,0)                   not null
       default 0,
    SPURL                VARCHAR(255) ,
    constraint PK_B_OBJ primary key (OBJ)
);

alter table B_OBJ
   add constraint AK_OID_B_OBJ unique (ID, ONS);

create index B_IX_OBJ2CLS on B_OBJ(
   CLS
); 

create index IX_B_OBJ_DEF on B_OBJ(
   DEF
); 

create table B_PAR (
    OBJ                  INT                            not null,
    BIN                  lo,
    constraint PK_B_PAR primary key (OBJ)
);

create table B_PROFS (
    STRSID               VARCHAR(255)          not null,
    PSTRSID              VARCHAR(255)          ,
    NAM                  VARCHAR(2000) ,
    BIN                  lo,	
    constraint PK_B_PROFS primary key (STRSID)
);

create table B_RDS_ELEM_REF (
    "KEY"                  INT                            not null,
    DICT_KEY             INT                            not null,
    ELEM_KEY             INT                            not null,
    REF                  INT                            not null,
    constraint PK_B_RDS_ELEM_REF primary key ("KEY")
);

create index B_IX_RDS_ELEM_REF_REF on B_RDS_ELEM_REF(
   REF
); 

create index B_IX_RDS_ELEM_REF_DICT_ELEM on B_RDS_ELEM_REF(
   DICT_KEY,
   ELEM_KEY
); 

create table B_SAC (
    US_SID               VARCHAR(127)          not null,
    STAMP                TIMESTAMP                      not null,
    BIN                  lo,
    constraint PK_B_SAC primary key (US_SID)
);

create table B_SD (
    SD                   INT                            not null,
    BIN                  lo,
    HSH                  VARCHAR(32) ,
    constraint PK_B_SD primary key (SD)
);

create index IDX_SD_HSH on B_SD(
   HSH
); 

create table B_SEC (
    SEC                  INT                            not null,
    STAMP                TIMESTAMP                      not null,
    BIN                  lo,
    constraint PK_B_SEC primary key (SEC)
);

create table B_SEC_DAT (
    DAT                  INT                            not null,
    ID                   VARCHAR(127)          not null,
    VI                   INT,
    VS                   VARCHAR(255) ,
    constraint PK_B_SEC_DAT primary key (DAT)
);

alter table B_SEC_DAT
   add constraint AK_SEC_DATID_B_SEC_DA unique (ID);

create table B_SEC_DATH (
    IDVAL                VARCHAR(255)          not null,
    INDEXVAL             INT                            not null,
    STRVAL               VARCHAR(2000) ,
    constraint PK_B_SEC_DATH primary key (IDVAL, INDEXVAL)
);

create table B_SEC_STA (
    STA                  INT                            not null,
    ID                   VARCHAR(127)          not null,
    TYP                  NUMERIC(2,0)                   not null,
    DOM                  INT                            not null,
    ACC                  NUMERIC(2,0)                   not null,
    constraint PK_B_SEC_STA primary key (STA)
);

alter table B_SEC_STA
   add constraint AK_SEC_STAID_B_SEC_ST unique (ID, TYP, DOM);

create table B_USR (
    USR                  VARCHAR(127)          not null,
    LOGERR               INT                            not null,
    LOGLCK               NUMERIC(1,0)                   not null,
    PWDSTAMP             TIMESTAMP,
    PSWLCK               NUMERIC(1,0),
    LCKSTAMP             TIMESTAMP,
    LOGSTAMP             TIMESTAMP,
    UPC varchar(2000),
    constraint PK_B_USR primary key (USR)
);

alter table B_CAC
    add constraint FK_B_CAC_COBJ2OBJ_B_OBJ foreign key (OBJ)
       references B_OBJ (OBJ) ON DELETE CASCADE;

alter table B_CDAT
    add constraint FK_B_CDAT_CDAT2CAC_B_CAC foreign key (OBJ, CAC)
       references B_CAC (OBJ, CAC) ON DELETE CASCADE;

alter table B_CIO
    add constraint FK_B_CIO_CIO2OBJ_B_OBJ foreign key (OBJ)
       references B_OBJ (OBJ) ON DELETE CASCADE;

alter table B_DAT
    add constraint FK_B_DAT_DAT2OBJ_B_OBJ foreign key (OBJ)
       references B_OBJ (OBJ) ON DELETE CASCADE;

alter table B_DEP
    add constraint FK_B_DEP_DEPOBJ2OB_B_OBJ foreign key (OBJ)
       references B_OBJ (OBJ) ON DELETE CASCADE;

alter table B_DEP
    add constraint FK_B_DEP_DEPREF2OB_B_OBJ foreign key (REF)
       references B_OBJ (OBJ) ON DELETE CASCADE;

alter table B_HDAT
    add constraint FK_B_HDAT_HDAT2HOBJ_B_HOBJ foreign key (OBJ, HIS)
       references B_HOBJ (OBJ, HIS) ON DELETE CASCADE;

alter table B_HMOD
    add constraint FK_B_HMOD_HMOD2HOBJ_B_HOBJ foreign key (OBJ, HIS)
       references B_HOBJ (OBJ, HIS) ON DELETE CASCADE;

alter table B_HPAR
    add constraint FK_B_HPAR_HPAR2HOBJ_B_HOBJ foreign key (OBJ, HIS)
       references B_HOBJ (OBJ, HIS) ON DELETE CASCADE;

alter table B_MOD
    add constraint FK_B_MOD_MOD2OBJ_B_OBJ foreign key (OBJ)
       references B_OBJ (OBJ) ON DELETE CASCADE;

alter table B_NAM
    add constraint FK_B_NAM_NAM2LCL_B_LCL foreign key (LCL)
       references B_LCL (LCL) ON DELETE CASCADE;

alter table B_NAM
    add constraint FK_B_NAM_NAM2OBJ_B_OBJ foreign key (OBJ)
       references B_OBJ (OBJ) ON DELETE CASCADE;

alter table B_OBJ
    add constraint FK_B_OBJ_OBJ2SD_B_SD foreign key (SD)
       references B_SD (SD) ON DELETE CASCADE;

alter table B_OBJ
    add constraint FK_B_OBJ_PAR2OBJ_B_OBJ foreign key (PAR)
       references B_OBJ (OBJ) ON DELETE CASCADE;

alter table B_PAR
    add constraint FK_B_PAR_PAR2OBJ_B_OBJ foreign key (OBJ)
       references B_OBJ (OBJ) ON DELETE CASCADE;
create sequence B_KEYSEQ start with 50 increment by 1 maxvalue 99999999;

create sequence B_ETLSEQ start with 10 increment by 1 maxvalue 99999999;

create sequence B_LOGSEQ start with 10 increment by 1 maxvalue 99999999;

create sequence B_RDS_ELEM_REF_SEQ start with 1 increment by 1 maxvalue 99999999;
CREATE OR REPLACE function B_SEC_DAT_HASH(USERNAME varchar, PSWD varchar)
returns void as 
$BODY$
begin
	declare MAX_ID integer;
         myrowcount integer;
begin
	if (length(USERNMAE) > 0 and length(PSWD) > 0) then
		update B_SEC_DAT set VS = PSWD where ID = USERNAME;
		GET DIAGNOSTICS myrowcount = ROW_COUNT;
		if (myrowcount <= 0) then
			select nvl(MAX(DAT), 0) + 1 into MAX_ID from B_SEC_DAT;
			insert into B_SEC_DAT(DAT, ID, VI, VS) values (MAX_ID, USERNAME, 0, PSWD);
		end if;
	end if;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_SEC_DAT_VALUE(ids varchar)
returns varchar as 
$BODY$
begin
declare
  idstr varchar(127);
  valstr varchar(255);
  valnum integer;
  valco integer;
  curpos integer;
  lastpos integer;
  findpos integer;
  res varchar(2000);
  reslo varchar(2000);
begin
  res := '';
  curpos := 1;
  lastpos := length(ids);
  while curpos<=lastpos loop
    findpos := position(',' in substring(ids from curpos));
    if findpos<=0 then
      findpos := lastpos+1;
    end if;
    idstr := substring(ids from curpos for findpos-1);
    select count(*),max(b.VI),max(b.VS) into valco,valnum,valstr from B_SEC_DAT b where b.ID=idstr;
    if (valco<=0) or (valnum is null) then
      valnum := 0;
    end if;
    if (valco<=0) or (valstr is null) then
      valstr := '';
    end if;
    res := res||idstr||'=VI='||cast(valnum as varchar)||'=VS="'||valstr||'";';

    if findpos>0 then
      findpos := findpos+curpos-1;  
    end if;
    
    curpos := findpos+1;
  end loop;
  reslo := res;
  return reslo;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_PWDSTA(USRLO varchar, PWDS  TIMESTAMP)
returns void as 
$BODY$
begin
declare USN varchar(127);
 myrowcount integer;
begin
 USN := upper(USRLO);
 update B_USR set PWDSTAMP = PWDS where USR = USN;
 GET DIAGNOSTICS myrowcount = ROW_COUNT;
 if (myrowcount <= 0) then
  insert into B_USR(USR, LOGERR, LOGLCK, PWDSTAMP) values (USN, 0, 0, PWDS);
 end if;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_USR_CHECK(username varchar)
returns varchar as 
$BODY$
begin
declare
 RES varchar(2000);
begin
   select upc into res from B_USR where usr=username and pwdstamp is not null;
   return res;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOGNCHECK(USRLO varchar, USRSTA varchar,
USRDOM varchar)
returns varchar as 
$BODY$
begin
declare
RESLO varchar(2000);
CO integer; SN varchar(127); LCO integer; PCO integer; RES varchar(255);
RK integer; DK integer; SK integer; AC integer;
begin
 SN := upper(USRLO);
 RES := '';
 select count(*), max(LOGLCK), max(PSWLCK) into CO, LCO, PCO from B_USR where USR = SN;
 if (CO=0) or (LCO is null) or (LCO < 0) then LCO := 0; end if;
 if (CO=0) or (PCO is null) or (PCO < 0) then PCO := 0; end if;
 RES := RES || ' USER_EXISTS=' || cast(CO as varchar);
 RES := RES || ' USER_LOCKED=' || cast(LCO + PCO as varchar);
 AC := 0;
 SN := 'R';
 select count(*), max(STA) into CO, RK from B_SEC_STA
  where ID = SN and TYP = 1 and DOM = 0;
 if CO > 0 then
  SN := upper(USRDOM);
  select count(*), max(STA) into CO, DK from B_SEC_STA
   where ID = SN and TYP = 2 and DOM = RK;
  if CO > 0 then
   SN := upper(USRSTA);
   select count(*), max(STA) into CO, SK from B_SEC_STA
    where ID = SN and TYP = 3 and DOM = DK;

   if CO > 0 then
    select ACC into AC from B_SEC_STA where STA = SK;
   end if;
   if AC = 0 then
    select ACC into AC from B_SEC_STA where STA = DK;
    if AC <> 0 then
     if CO = 0 then -- invert
      if AC = 1 then
       AC := 2;
      elsif AC = 2 then
       AC := 1;
      end if;
     end if;
    end if;
   end if;
  end if;
  if AC = 0 then
   select ACC into AC from B_SEC_STA where STA = RK;
   if AC <> 0 then
    if CO <> 0 then -- invert
     if AC = 1 then
      AC := 2;
     elsif AC = 2 then
      AC := 1;
     end if;
    end if;
   end if;
  end if;
 end if;
 RES := RES || ' STATION_ACCESS=' || cast(AC as varchar);
 RESLO := RES;
 return reslo;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOGNSUC(USRLO varchar, USRSTA varchar,
USRDOM varchar)
returns varchar as 
$BODY$
begin
declare USN varchar(127); RES varchar(255);
RESLO varchar(2000);
begin
 USN := upper(USRLO);
 PERFORM B_LOGNLOG(true, USN);
 select * into res from B_LOGNCHECK(USN, USRSTA, USRDOM);
 RESLO := RES;
 return reslo;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOGSUC(USRLO varchar, USRSTA varchar,
USRDOM varchar)
returns varchar as 
$BODY$
begin
declare USN varchar(127); RES varchar(255);
RESLO varchar(2000);
begin
 USN := upper(USRLO);
 PERFORM B_LOGNLOG(true, USN);
 select * into res from B_LOGNCHECK(USN, USRSTA, USRDOM);
 RESLO := RES;
 return reslo;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOGNLOG(ISSUCC boolean, USRLO varchar)
returns void as 
$BODY$
begin
declare
 CO integer;
 MAXE integer; -- max logon errors
 RESE integer; -- errors reset timeout
 OECO integer; NECO integer; -- logon errors count
 OLCO integer; NLCO integer; -- logon locked by error count
 OSTM TIMESTAMP; NSTM TIMESTAMP; -- logon stamp
 LSTM TIMESTAMP; -- last login stamp
 USN varchar(127);
 myrowcount integer;
begin
  select count(*), max(VI) into CO, MAXE from B_SEC_DAT where ID = 'MAXE';
 if CO = 0 or MAXE is null then
  MAXE := 0;
 end if;
 select count(*), max(VI) into CO, RESE from B_SEC_DAT where ID = 'RESE';
 if CO = 0 or RESE is null then
  RESE := 0;
 end if;
 USN := upper(USRLO);
 select count(*), max(LOGERR), /*max(B_USR.LOGLCK), */max(PSWLCK), max(LCKSTAMP)
 into CO, OECO, OLCO, OSTM from B_USR where USR = USN;
 NSTM := CURRENT_TIMESTAMP;
 LSTM := CURRENT_TIMESTAMP;
 if CO = 0 then
  OECO := 0;
  OLCO := 0;
  OSTM := null;
 else
  if OECO is null or OECO < 0 then OECO := 0; end if;
  if OLCO is null or OLCO < 0 then OLCO := 0; end if;
  if OSTM is null then OSTM := NSTM; end if;
 end if;
 if ISSUCC then
  NECO := 0;
 else
  if OSTM is not null and RESE > 0 and
    NSTM > (OSTM + (RESE * INTERVAL '1' SECOND)) then --1.0 / (60 * 60 * 24);
    --NSTM > (OSTM + NUMTODSINTERVAL(RESE, 'SECOND')) then
    OECO := 0;
  end if;
  OECO := OECO + 1;
  NECO := OECO;
 end if;
 if OLCO = 0 and MAXE > 0 and NECO >= MAXE then
  NLCO := 1;
 else
  NLCO := OLCO;
 end if;
 if CO > 0 then
  if NLCO = OLCO then
   update B_USR set LCKSTAMP = NSTM, LOGERR = NECO, LOGSTAMP = LSTM where USR = USN;
  else
   --update B_USR set LOGERR = NECO, LOGLCK = NLCO where USR = USN;
    update B_USR set LCKSTAMP = NSTM, LOGERR = NECO, PSWLCK = NLCO, LOGSTAMP = LSTM where USR = USN;
  end if;
  GET DIAGNOSTICS myrowcount = ROW_COUNT;
  if (myrowcount = 0) then
   CO := 0;
  end if;
 end if;
 if CO = 0 then
  --insert into B_USR(USR, LOGERR, LOGLCK) values (USN, NECO, NLCO);
  insert into B_USR(USR, LCKSTAMP, LOGERR, PSWLCK, LOGLCK, LOGSTAMP) values (USN, NSTM, NECO, NLCO, 0, LSTM);
 end if;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOGNERR(USRLO varchar, USRSTA varchar, USRDOM varchar,
USROS varchar, USRIP varchar, EMSG varchar)
returns varchar as 
$BODY$
begin
declare USN varchar(127); RES varchar(255); L_EMSG varchar(255);
RESLO varchar(2000);
UBB integer; UBN integer;
begin
 USN := upper(USRLO);
 select max(LOGLCK) into UBB from B_USR where USR = USN;
 PERFORM B_LOGNLOG(false, USN);
 select max(LOGLCK) into UBN from B_USR where USR = USN;
 L_EMSG := EMSG;
 if (UBN>0) then
    L_EMSG := '%1'; 
 end if;
 insert into B_JLO(SES, STAMP, STAMP_OUT, US_SID, US_NAM, US_DES, US_STA, US_OS, US_IP, ALLO, CMNT)
 values (nextval('B_LOGSEQ'), CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, USN, USN, USN, USRSTA, USROS, USRIP, 0, L_EMSG);
 if (UBN!=UBB) then
    insert into B_JAU(SES, STAMP, OP_KEY, OP_POS, OP_LVL, 
        OP_NAM, OP_MSK, OP_SUC, OBJ_KEY, OBJ_ID, OBJ_NAM, OBJ_CLS, 
        CMNT, OCL) 
    values (currval('B_KEYSEQ'), CURRENT_TIMESTAMP, 1, 0, 0, 
        '%4', 2097152, 1, -1,'METABASESECURITY', '%3', 7937, 
        '%2,' || USN , 0) ;
 end if;
 select B_LOGNCHECK(USN, USRSTA, USRDOM) into RES;
 RESLO := RES;
 return reslo;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOGERR(USRLO varchar, USRSTA varchar, USRDOM varchar,
USROS varchar, USRIP varchar, EMSG varchar)
returns void as 
$BODY$
begin
declare USN varchar(127); RES varchar(255); L_EMSG varchar(255);
RESLO varchar(2000);
UBB integer; UBN integer;
begin
 USN := upper(USRLO);
 select max(LOGLCK) into UBB from B_USR where USR = USN;
 PERFORM B_LOGNLOG(false, USN);
 select max(LOGLCK) into UBN from B_USR where USR = USN;
 L_EMSG := EMSG;
 if (UBN>0) then
    L_EMSG := '%1'; 
 end if;
 insert into B_JLO(SES, STAMP, STAMP_OUT, US_SID, US_NAM, US_DES, US_STA, US_OS, US_IP, ALLO, CMNT)
 values (B_LOGSEQ.nextval, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, USN, USN, USN, USRSTA, USROS, USRIP, 0, L_EMSG);
 if (UBN!=UBB) then
    insert into B_JAU(SES, STAMP, OP_KEY, OP_POS, OP_LVL, 
        OP_NAM, OP_MSK, OP_SUC, OBJ_KEY, OBJ_ID, OBJ_NAM, OBJ_CLS, 
        CMNT, OCL) 
    values (B_KEYSEQ.CURRVAL, CURRENT_TIMESTAMP, 1, 0, 0, 
        '%4', 2097152, 1, -1,'METABASESECURITY', '%3', 7937, 
        '%2,' || USN , 0) ;
 end if;
 select B_LOGNCHECK(USN, USRSTA, USRDOM) into RES;
 RESLO := RES;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_DU_SAVE(NAMESES varchar)
returns void as 
$BODY$
begin
       insert into B_DU values(NAMESES,CURRENT_TIMESTAMP);
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_DU_CLEAR(NAMESES varchar)
returns void as 
$BODY$
begin
      delete from B_DU where NAMESESSION = NAMESES;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_DU_CHK(SESSTR varchar,SESID numeric)
returns numeric as 
$BODY$
begin
declare
   iserror integer;
   RES numeric;
begin
   select count(NAMESESSION) into iserror from B_DU where NAMESESSION = SESSTR and STAMP>CURRENT_TIMESTAMP-1;
   if(iserror>0) then
       PERFORM B_DU_CLEAR(SESSTR);
       update b_jlo set cmnt_out = '%15' ,STAMP_OUT = CURRENT_TIMESTAMP where SES = SESID;
       RES := 1;
   else
       RES := 0;
   end if;
   return RES;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_PGRREVT(ISGRANT numeric, USRNAME varchar, TABNAME varchar, ACCESSMASK varchar, POSTFIX varchar)
returns void as 
$BODY$
begin
declare
	dyn_sql varchar(512);
	grantsStr varchar(512);
begin
	dyn_sql := '';
	grantsStr :='';
	if not (SUBSTRING(UPPER(TABNAME) FROM 1 FOR 2)='B_') then
      	   RAISE EXCEPTION 'Invalid object name(%)',TABNAME;
	end if;
	if POSITION('SELECT' in UPPER(ACCESSMASK))<>0 then
		grantsStr := 'SELECT';
	end if;
	if POSITION('USAGE' in UPPER(ACCESSMASK))<>0 then
		grantsStr := 'USAGE';
	end if;
	if POSITION('UPDATE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'UPDATE';
	end if;
	if POSITION('DELETE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'DELETE';
	end if;
	if POSITION('ALL' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'ALL';
	end if;
	if POSITION('INSERT' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'INSERT';
	end if;
	if POSITION('EXECUTE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'EXECUTE';
		if position(UPPER('b_du_chk') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_chk(sesstr character varying, sesid numeric)';
		end if;
		if position(UPPER('b_du_clear') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_clear(nameses character varying)';
		end if;
		if position(UPPER('b_du_save') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_save(nameses character varying)';
		end if;
		if position(UPPER('b_logncheck') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logncheck(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_lognerr') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognerr(usrlo character varying, usrsta character varying, usrdom character varying, usros character varying, usrip character varying, emsg character varying)';
		end if;
		if position(UPPER('b_logerr') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logerr(usrlo character varying, usrsta character varying, usrdom character varying, usros character varying, usrip character varying, emsg character varying)';
		end if;
		if position(UPPER('b_lognlog') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognlog(issucc boolean, usrlo character varying)';
		end if;
		if position(UPPER('b_lognsuc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognsuc(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_logsuc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logsuc(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_pgrexecgrrev') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pgrexecgrrev(isgrant numeric, usrname character varying)';
		end if;
		if position(UPPER('b_pgrrevt') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pgrrevt(isgrant numeric, usrname character varying, tabname character varying, accessmask character varying, postfix character varying)';
		end if;
		if position(UPPER('b_prevgrproc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_prevgrproc(usrname character varying)';
		end if;
		if position(UPPER('b_pwdsta') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pwdsta(usrlo character varying, pwds timestamp without time zone)';
		end if;
		if position(UPPER('b_sec_dat_hash') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_sec_dat_hash(username character varying, pswd character varying)';
		end if;
		if position(UPPER('b_sec_dat_value') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_sec_dat_value(ids character varying)';
		end if;
		if position(UPPER('b_usr_check') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_usr_check(username character varying)';
		end if;
	end if;
	if ISGRANT = 1 then
		dyn_sql := dyn_sql || 'grant '||grantsStr||' on ' || UPPER(TABNAME) || ' to "';
	else
		dyn_sql := dyn_sql || 'revoke '||grantsStr||' on '|| UPPER(TABNAME) || ' from "';
	end if;
    dyn_sql := dyn_sql || USRNAME||'"';
	--if length(POSTFIX) > 0 then
		--dyn_sql := dyn_sql || ' ';
		--dyn_sql := dyn_sql || POSTFIX;
	--end if;
	execute dyn_sql;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_PGREXECGRREV(ISGRANT numeric, USRNAME varchar)
returns void as 
$BODY$
begin
declare
    dyn_sql varchar(512);
begin
    dyn_sql := '';
    if ISGRANT = 1 then
        dyn_sql := dyn_sql || 'grant execute on FUNCTION B_PGRREVT(isgrant numeric, usrname character varying, tabname character varying, accessmask character varying, postfix character varying) to "';
    else
        dyn_sql := dyn_sql || 'revoke execute on FUNCTION B_PGRREVT(isgrant numeric, usrname character varying, tabname character varying, accessmask character varying, postfix character varying) from "';
    end if;
    dyn_sql := dyn_sql || USRNAME||'"';
    execute dyn_sql;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_PREVGRPROC(USRNAME varchar)
returns void as 
$BODY$
begin
declare
    dyn_sql varchar(512);
begin
    dyn_sql := '';
    dyn_sql := dyn_sql || 'revoke all on function B_PGRREVT(isgrant numeric, usrname character varying, tabname character varying, accessmask character varying, postfix character varying) from "';
    dyn_sql := dyn_sql || USRNAME ||'"';
    execute dyn_sql;
    dyn_sql := '';
    dyn_sql := dyn_sql || 'revoke all on function B_PGREXECGRREV(isgrant numeric, usrname character varying) from "';
    dyn_sql := dyn_sql || USRNAME ||'"';
    execute dyn_sql;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;
create view B_USR_V(USR, LOGLCK, PWDSTAMP, PSWLCK, LCKSTAMP, LOGSTAMP)
as select a.USR, a.LOGLCK, a.PWDSTAMP, a.PSWLCK, a.LCKSTAMP, a.LOGSTAMP from B_USR a;

insert into B_LAST(LAS, VER) values (0, 131);

--
create or replace function B_LOGNERR(USRLO varchar, USRSTA varchar, USRDOM varchar,
USROS varchar, USRIP varchar, EMSG varchar)
returns varchar as 
$BODY$
begin
declare USN varchar(127); RES varchar(255); L_EMSG varchar(255); CTS date;
RESLO varchar(2000);
UBB integer; UBN integer;
begin
 USN := upper(USRLO);
 select max(LOGLCK) into UBB from B_USR where USR = USN;
 PERFORM B_LOGNLOG(false, USN);
 select max(LOGLCK) into UBN from B_USR where USR = USN;
 L_EMSG := EMSG;
 if (UBN>0) then
    L_EMSG := '%1'; 
 end if;
 insert into B_JLO(SES, STAMP, STAMP_OUT, US_SID, US_NAM, US_DES, US_STA, US_OS, US_IP, ALLO, CMNT)
 values (nextval('B_LOGSEQ'), CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, USN, USN, USN, USRSTA, USROS, USRIP, 0, L_EMSG);
 if (UBN!=UBB) then
    CTS := CURRENT_TIMESTAMP + (1 / 86400);
    insert into B_JAU(SES, STAMP, OP_KEY, OP_POS, OP_LVL, 
        OP_NAM, OP_MSK, OP_SUC, OBJ_KEY, OBJ_ID, OBJ_NAM, OBJ_CLS, 
        CMNT, OCL) 
    values (currval('B_KEYSEQ'), CTS, 1, 0, 0, 
        '%4', 2097152, 1, -1,'METABASESECURITY', '%3', 7937, 
        '%2,' || USN , 0) ;
 end if;
 select B_LOGNCHECK(USN, USRSTA, USRDOM) into RES;
 RESLO := RES;
 return reslo;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

update B_LAST set VER = 132;


create  index B_IX_JAU2CLS on B_JAU (OBJ_CLS);

update B_LAST set VER = 133;


update B_LAST set VER = 134;


create table B_SCSH (
    OBJ  int  not null,
    SST int not null,
    BIN  lo,
    constraint PK_B_SCSH primary key (OBJ, SST)
);

alter table B_SCSH
    add constraint FK_B_SCSH_B_OBJ foreign key (OBJ)
       references B_OBJ (OBJ) ON DELETE CASCADE;

update B_LAST set VER = 135;


create table B_USD
(
  US_SID             VARCHAR(127)         NOT NULL, 
  US_NAM             VARCHAR(255)         NOT NULL, 
  STAMP              TIMESTAMP            NOT NULL, 
  EXTE               NUMERIC(2,0)         NOT NULL,
  FLG                NUMERIC(9,0)         NOT NULL,
  BIN                lo,
    constraint PK_B_USD primary key (US_SID)
);

alter table B_USD
   add constraint AK_US_NAM_B_USD unique (US_NAM);

create view B_USD_V(US_SID, US_NAM, STAMP, EXTE, FLG, BIN)
as select a.US_SID, a.US_NAM, a.STAMP, a.EXTE, a.FLG, a.BIN from B_USD a;

update B_LAST set VER = 136;


drop index if exists B_JAU_SES;

create index B_JAU_SES ON B_JAU (SES, STAMP);

drop index if exists B_JLO_SES;

create  index B_JLO_SES on B_JLO (SES, STAMP, STAMP_OUT);

update B_LAST set VER = 137;


create table B_CER
(
  CER_K              NUMERIC(9,0)          not null,
  ID                 VARCHAR(127)          not null, 
  NAM                VARCHAR(255)          not null, 
  FLG                NUMERIC(9,0)          not null,
  DAT                VARCHAR(2000),
    constraint PK_B_CER primary key (CER_K)
);

create view B_CER_V(CER_K, ID, NAM, FLG, DAT)
as select a.CER_K, a.ID, a.NAM, a.FLG, a.DAT from B_CER a;

update B_LAST set VER = 138;


update B_LAST set VER = 139;


CREATE SEQUENCE B_RDS_OBJELEM_REF_SEQ
  INCREMENT 1
  START 1
  MAXVALUE 99999999;

create table B_RDS_OBJELEM_REF (
    "KEY"  int  not null,
    DICT_KEY int not null,
    ELEM_KEY INT NOT NULL,
    REF INT NOT NULL,
    constraint PK_B_RDS_OBJELEM_REF primary key ("KEY")
);

create index B_IX_RDS_OBJELEM_REF_REF on B_RDS_OBJELEM_REF(
   REF
);

create index B_IX_RDS_OBJELEM_REF_DICT_ELEM on B_RDS_OBJELEM_REF(
   DICT_KEY,
   ELEM_KEY
); 

update B_LAST set VER = 140;


update B_LAST set VER = 141;


update B_LAST set VER = 142;


create table B_GL (
    gl  int
);

insert into B_GL values(0);

update B_LAST set VER = 143;


update B_LAST set VER = 144;


update B_LAST set VER = 145;


alter table B_USR add column CRTSTAMP TIMESTAMP;

create or replace view B_USR_V(USR, LOGLCK, PWDSTAMP, PSWLCK, LCKSTAMP, LOGSTAMP, CRTSTAMP)
as select a.USR, a.LOGLCK, a.PWDSTAMP, a.PSWLCK, a.LCKSTAMP, a.LOGSTAMP, a.CRTSTAMP from B_USR a;

create or replace function B_PWDSTA(USRLO varchar, PWDS TIMESTAMP, CRTUPD boolean)
returns void as 
$BODY$
begin
declare USN varchar(127);
 myrowcount integer;
begin
 USN := upper(USRLO);
 if (CRTUPD) then
  update B_USR set PWDSTAMP = PWDS, CRTSTAMP = PWDS where USR = USN;
 else
  update B_USR set PWDSTAMP = PWDS where USR = USN;
 end if;
 GET DIAGNOSTICS myrowcount = ROW_COUNT;
 if (myrowcount <= 0) then
  insert into B_USR(USR, LOGERR, LOGLCK, PWDSTAMP, CRTSTAMP) values (USN, 0, 0, PWDS, PWDS);
 end if;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOCKTMP(USRLO varchar)
returns void as 
$BODY$
begin
declare USN varchar(127);
declare LSTM TIMESTAMP;
begin
 USN := upper(USRLO);
 LSTM := CURRENT_TIMESTAMP;

 update B_USR set B_USR.LOGLCK = 3, B_USR.LCKSTAMP = LSTM where B_USR.USR = USN;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

update B_LAST set VER = 146;


alter table B_USR add column DLTSTAMP TIMESTAMP;

create or replace view B_USR_V(USR, LOGLCK, PWDSTAMP, PSWLCK, LCKSTAMP, LOGSTAMP, CRTSTAMP, DLTSTAMP)
as select a.USR, a.LOGLCK, a.PWDSTAMP, a.PSWLCK, a.LCKSTAMP, a.LOGSTAMP, a.CRTSTAMP, a.DLTSTAMP from B_USR a;

drop function if exists B_LCKTMP(varchar);

drop function if exists B_LOCKTMP(varchar);

create or replace function B_PWDSTA(USRLO varchar, PWDS TIMESTAMP, CRTUPD boolean)
returns void as 
$BODY$
begin
declare USN varchar(127);
 myrowcount integer;
begin
 USN := upper(USRLO);
 if (CRTUPD) then
  update B_USR set PWDSTAMP = PWDS, CRTSTAMP = PWDS, DLTSTAMP = NULL where USR = USN;
 else
  update B_USR set PWDSTAMP = PWDS where USR = USN;
 end if;
 GET DIAGNOSTICS myrowcount = ROW_COUNT;
 if (myrowcount <= 0) then
  insert into B_USR(USR, LOGERR, LOGLCK, PWDSTAMP, CRTSTAMP) values (USN, 0, 0, PWDS, PWDS);
 end if;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOCKUSER(USRLO varchar, LCKFLAG integer)
returns void as 
$BODY$
begin
declare USN varchar(127);
declare LSTM TIMESTAMP;
begin
 USN := upper(USRLO);
 LSTM := CURRENT_TIMESTAMP;

 update B_USR set LOGLCK = LCKFLAG, LCKSTAMP = LSTM where USR = USN;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_DLTUSER(USRLO varchar)
returns void as 
$BODY$
begin
declare USN varchar(127);
declare LSTM TIMESTAMP;
begin
 USN := upper(USRLO);
 LSTM := CURRENT_TIMESTAMP;

 update B_USR set DLTSTAMP = LSTM where USR = USN;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_PGRREVT(ISGRANT numeric, USRNAME varchar, TABNAME varchar, ACCESSMASK varchar, POSTFIX varchar)
returns void as 
$BODY$
begin
declare
	dyn_sql varchar(512);
	grantsStr varchar(512);
begin
	dyn_sql := '';
	grantsStr :='';
	if not (SUBSTRING(UPPER(TABNAME) FROM 1 FOR 2)='B_') then
      	   RAISE EXCEPTION 'Invalid object name(%)',TABNAME;
	end if;
	if POSITION('SELECT' in UPPER(ACCESSMASK))<>0 then
		grantsStr := 'SELECT';
	end if;
	if POSITION('USAGE' in UPPER(ACCESSMASK))<>0 then
		grantsStr := 'USAGE';
	end if;
	if POSITION('UPDATE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'UPDATE';
	end if;
	if POSITION('DELETE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'DELETE';
	end if;
	if POSITION('ALL' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'ALL';
	end if;
	if POSITION('INSERT' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'INSERT';
	end if;
	if POSITION('EXECUTE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'EXECUTE';
		if position(UPPER('b_du_chk') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_chk(sesstr character varying, sesid numeric)';
		end if;
		if position(UPPER('b_du_clear') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_clear(nameses character varying)';
		end if;
		if position(UPPER('b_du_save') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_save(nameses character varying)';
		end if;
		if position(UPPER('b_logncheck') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logncheck(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_lognerr') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognerr(usrlo character varying, usrsta character varying, usrdom character varying, usros character varying, usrip character varying, emsg character varying)';
		end if;
		if position(UPPER('b_logerr') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logerr(usrlo character varying, usrsta character varying, usrdom character varying, usros character varying, usrip character varying, emsg character varying)';
		end if;
		if position(UPPER('b_lognlog') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognlog(issucc boolean, usrlo character varying)';
		end if;
		if position(UPPER('b_lognsuc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognsuc(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_logsuc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logsuc(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_pgrexecgrrev') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pgrexecgrrev(isgrant numeric, usrname character varying)';
		end if;
		if position(UPPER('b_pgrrevt') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pgrrevt(isgrant numeric, usrname character varying, tabname character varying, accessmask character varying, postfix character varying)';
		end if;
		if position(UPPER('b_prevgrproc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_prevgrproc(usrname character varying)';
		end if;
		if position(UPPER('b_pwdsta') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pwdsta(usrlo character varying, pwds timestamp without time zone)';
		end if;
		if position(UPPER('b_sec_dat_hash') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_sec_dat_hash(username character varying, pswd character varying)';
		end if;
		if position(UPPER('b_sec_dat_value') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_sec_dat_value(ids character varying)';
		end if;
		if position(UPPER('b_usr_check') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_usr_check(username character varying)';
		end if;
		if position(UPPER('b_lockuser') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lockuser(usrlo character varying, lckflag integer)';
		end if;
		if position(UPPER('b_dltuser') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_dltuser(usrlo character varying)';
		end if;



	end if;
	if ISGRANT = 1 then
		dyn_sql := dyn_sql || 'grant '||grantsStr||' on ' || UPPER(TABNAME) || ' to "';
	else
		dyn_sql := dyn_sql || 'revoke '||grantsStr||' on '|| UPPER(TABNAME) || ' from "';
	end if;
    dyn_sql := dyn_sql || USRNAME||'"';
	--if length(POSTFIX) > 0 then
		--dyn_sql := dyn_sql || ' ';
		--dyn_sql := dyn_sql || POSTFIX;
	--end if;
	execute dyn_sql;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

update B_LAST set VER = 147;


alter table B_SEC add column BIN_HASH varchar(45) default 'N8bYUG+On+Y2R5GRiUQDFnOJ32RCzDumICd9c29lXWc=' not null;

update B_LAST set VER = 148;


ALTER TABLE B_JAU ADD COLUMN "KEY" DECIMAL(30,0);
CREATE SEQUENCE B_JAU_KEY_SEQ;
UPDATE B_JAU SET "KEY" = NEXTVAL('B_JAU_KEY_SEQ');
ALTER TABLE B_JAU ALTER "KEY" SET DEFAULT NEXTVAL('B_JAU_KEY_SEQ');
ALTER TABLE ONLY B_JAU ADD CONSTRAINT PK_B_JAU_KEY PRIMARY KEY("KEY");

update B_LAST set VER = 149;


ALTER TABLE b_jlo ADD COLUMN ses_id integer;

ALTER TABLE b_du DROP CONSTRAINT pk_b_du;

update B_LAST set VER = 150;


create or replace function B_LOGERR(USRLO varchar, USRSTA varchar, USRDOM varchar,
USROS varchar, USRIP varchar, EMSG varchar)
returns void as 
$BODY$
begin
declare USN varchar(127); RES varchar(255); L_EMSG varchar(255);
RESLO varchar(2000);
UBB integer; UBN integer; CTS timestamp with time zone;
begin
 USN := upper(USRLO);
 CTS := CURRENT_TIMESTAMP at time zone 'utc';
 select max(LOGLCK) into UBB from B_USR where USR = USN;
 PERFORM B_LOGNLOG(false, USN);
 select max(LOGLCK) into UBN from B_USR where USR = USN;
 L_EMSG := EMSG;
 if (UBN>0) then
    L_EMSG := '%1'; 
 end if;
 insert into B_JLO(SES, STAMP, STAMP_OUT, US_SID, US_NAM, US_DES, US_STA, US_OS, US_IP, ALLO, CMNT)
 values (B_LOGSEQ.nextval, CTS, CTS, USN, USN, USN, USRSTA, USROS, USRIP, 0, L_EMSG);
 if (UBN!=UBB) then
    insert into B_JAU(SES, STAMP, OP_KEY, OP_POS, OP_LVL, 
        OP_NAM, OP_MSK, OP_SUC, OBJ_KEY, OBJ_ID, OBJ_NAM, OBJ_CLS, 
        CMNT, OCL) 
    values (B_KEYSEQ.CURRVAL, CTS, 1, 0, 0, 
        '%4', 2097152, 1, -1,'METABASESECURITY', '%3', 7937, 
        '%2,' || USN , 0) ;
 end if;
 select B_LOGNCHECK(USN, USRSTA, USRDOM) into RES;
 RESLO := RES;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOGNERR(USRLO varchar, USRSTA varchar, USRDOM varchar,
USROS varchar, USRIP varchar, EMSG varchar)
returns varchar as 
$BODY$
begin
declare USN varchar(127); RES varchar(255); L_EMSG varchar(255); CTS timestamp with time zone;
RESLO varchar(2000);
UBB integer; UBN integer;
begin
 USN := upper(USRLO);
 CTS := CURRENT_TIMESTAMP at time zone 'utc';
 select max(LOGLCK) into UBB from B_USR where USR = USN;
 PERFORM B_LOGNLOG(false, USN);
 select max(LOGLCK) into UBN from B_USR where USR = USN;
 L_EMSG := EMSG;
 if (UBN>0) then
    L_EMSG := '%1'; 
 end if;
 insert into B_JLO(SES, STAMP, STAMP_OUT, US_SID, US_NAM, US_DES, US_STA, US_OS, US_IP, ALLO, CMNT)
 values (nextval('B_LOGSEQ'), CTS, CTS, USN, USN, USN, USRSTA, USROS, USRIP, 0, L_EMSG);
 if (UBN!=UBB) then
    CTS := CTS + (1 / 86400);
    insert into B_JAU(SES, STAMP, OP_KEY, OP_POS, OP_LVL, 
        OP_NAM, OP_MSK, OP_SUC, OBJ_KEY, OBJ_ID, OBJ_NAM, OBJ_CLS, 
        CMNT, OCL) 
    values (currval('B_KEYSEQ'), CTS, 1, 0, 0, 
        '%4', 2097152, 1, -1,'METABASESECURITY', '%3', 7937, 
        '%2,' || USN , 0) ;
 end if;
 select B_LOGNCHECK(USN, USRSTA, USRDOM) into RES;
 RESLO := RES;
 return reslo;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_LOGNLOG(ISSUCC boolean, USRLO varchar)
returns void as 
$BODY$
begin
declare
 CO integer;
 MAXE integer; -- max logon errors
 RESE integer; -- errors reset timeout
 OECO integer; NECO integer; -- logon errors count
 OLCO integer; NLCO integer; -- logon locked by error count
 OSTM TIMESTAMP with time zone; NSTM TIMESTAMP with time zone; -- logon stamp
 LSTM TIMESTAMP with time zone; -- last login stamp
 USN varchar(127);
 myrowcount integer;
 FRESET integer; -- flag if pswlck date expired

begin
 FRESET := 0;
  select count(*), max(VI) into CO, MAXE from B_SEC_DAT where ID = 'MAXE';
 if CO = 0 or MAXE is null then
  MAXE := 0;
 end if;
 select count(*), max(VI) into CO, RESE from B_SEC_DAT where ID = 'RESE';
 if CO = 0 or RESE is null then
  RESE := 0;
 end if;
 USN := upper(USRLO);
 select count(*), max(LOGERR), /*max(B_USR.LOGLCK), */max(PSWLCK), max(LCKSTAMP)
 into CO, OECO, OLCO, OSTM from B_USR where USR = USN;
 NSTM := CURRENT_TIMESTAMP at time zone 'utc';
 LSTM := NSTM;
 if CO = 0 then
  OECO := 0;
  OLCO := 0;
  OSTM := null;
 else
  if OECO is null or OECO < 0 then OECO := 0; end if;
  if OLCO is null or OLCO < 0 then OLCO := 0; end if;
  if OSTM is null then OSTM := NSTM; end if;
 end if;
 if ISSUCC then
  NECO := 0;

  if OSTM is not null and OLCO = 1 and RESE > 0 and
    NSTM > (OSTM + (RESE * INTERVAL '1' SECOND)) then --1.0 / (60 * 60 * 24);
    --NSTM > (OSTM + NUMTODSINTERVAL(RESE, 'SECOND')) then
     OECO := 0;
     NECO := OECO;
     OLCO := 0;
     FRESET := 1;
  end if;

 else
  if OSTM is not null and RESE > 0 and
    NSTM > (OSTM + (RESE * INTERVAL '1' SECOND)) then --1.0 / (60 * 60 * 24);
    --NSTM > (OSTM + NUMTODSINTERVAL(RESE, 'SECOND')) then
    OECO := 0;
  end if;
  OECO := OECO + 1;
  NECO := OECO;
 end if;
 if OLCO = 0 and MAXE > 0 and NECO >= MAXE then
  NLCO := 1;
 else
  NLCO := OLCO;
 end if;
 if CO > 0 then
  if NLCO = OLCO and FRESET = 0 then
   update B_USR set LCKSTAMP = NSTM, LOGERR = NECO, LOGSTAMP = LSTM where USR = USN;
  else
   --update B_USR set LOGERR = NECO, LOGLCK = NLCO where USR = USN;
    update B_USR set LCKSTAMP = NSTM, LOGERR = NECO, PSWLCK = NLCO, LOGSTAMP = LSTM where USR = USN;
  end if;
  GET DIAGNOSTICS myrowcount = ROW_COUNT;
  if (myrowcount = 0) then
   CO := 0;
  end if;
 end if;
 if CO = 0 then
  --insert into B_USR(USR, LOGERR, LOGLCK) values (USN, NECO, NLCO);
  insert into B_USR(USR, LCKSTAMP, LOGERR, PSWLCK, LOGLCK, LOGSTAMP) values (USN, NSTM, NECO, NLCO, 0, LSTM);
 end if;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_DU_SAVE(NAMESES varchar)
returns void as 
$BODY$
begin
       insert into B_DU values(NAMESES,LOCALTIMESTAMP);
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_DU_CHK(SESSTR varchar,SESID numeric)
returns numeric as 
$BODY$
begin
declare
   iserror integer;
   RES numeric;
   CTS TIMESTAMP with time zone;
begin
   CTS := CURRENT_TIMESTAMP at time zone 'utc';
   select count(NAMESESSION) into iserror from B_DU where NAMESESSION = SESSTR and STAMP>CTS-1;
   if(iserror>0) then
       PERFORM B_DU_CLEAR(SESSTR);
       update b_jlo set cmnt_out = '%15' ,STAMP_OUT = CTS where SES = SESID;
       RES := 1;
   else
       RES := 0;
   end if;
   return RES;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_SEC_DAT_VALUE(ids varchar)
returns varchar as 
$BODY$
begin
declare
  idstr varchar(127);
  valstr varchar(255);
  valnum integer;
  valco integer;
  curpos integer;
  lastpos integer;
  findpos integer;
  res varchar(2000);
  reslo varchar(2000);
begin
  res := '';
  curpos := 1;
  lastpos := length(ids);
  while curpos<=lastpos loop
    findpos := position(',' in substring(ids from curpos));
    if findpos<=0 then
      findpos := lastpos+1;
    end if;
    idstr := substring(ids from curpos for findpos-1);
    select count(*),max(b.VI),max(b.VS) into valco,valnum,valstr from B_SEC_DAT b where b.ID=idstr;
    if (valco<=0) or (valnum is null) then
      valnum := 0;
    end if;
    if (valco<=0) or (valstr is null) then
      valstr := '';
    end if;
    res := res||idstr||'=VI='||cast(valnum as varchar)||'=VS="'||valstr||'";';

    if findpos>0 then
      findpos := findpos+curpos-1;  
    end if;
    
    curpos := findpos+1;
  end loop;
  reslo := res;
  return reslo;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

alter table B_PROFS alter column PSTRSID drop not NULL;

update B_LAST set VER = 151;


update B_LAST set VER = 152;


create or replace function B_LOGNERR_S(USRLO varchar, USRSTA varchar,
USROS varchar, USRIP varchar, EMSG varchar)
returns void as 
$BODY$
begin
declare USN varchar(127); CTS timestamp with time zone;
begin
 USN := upper(USRLO);
 CTS := CURRENT_TIMESTAMP at time zone 'utc';
 insert into B_JLO(SES, STAMP, STAMP_OUT, US_SID, US_NAM, US_DES, US_STA, US_OS, US_IP, ALLO, CMNT)
 values (nextval('B_LOGSEQ'), CTS, CTS, USN, USN, USN, USRSTA, USROS, USRIP, 0, EMSG);
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

create or replace function B_PGRREVT(ISGRANT numeric, USRNAME varchar, TABNAME varchar, ACCESSMASK varchar, POSTFIX varchar)
returns void as 
$BODY$
begin
declare
	dyn_sql varchar(512);
	grantsStr varchar(512);
begin
	dyn_sql := '';
	grantsStr :='';
	if not (SUBSTRING(UPPER(TABNAME) FROM 1 FOR 2)='B_') then
      	   RAISE EXCEPTION 'Invalid object name(%)',TABNAME;
	end if;
	if POSITION('SELECT' in UPPER(ACCESSMASK))<>0 then
		grantsStr := 'SELECT';
	end if;
	if POSITION('USAGE' in UPPER(ACCESSMASK))<>0 then
		grantsStr := 'USAGE';
	end if;
	if POSITION('UPDATE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'UPDATE';
	end if;
	if POSITION('DELETE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'DELETE';
	end if;
	if POSITION('ALL' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'ALL';
	end if;
	if POSITION('INSERT' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'INSERT';
	end if;
	if POSITION('EXECUTE' IN UPPER(ACCESSMASK))<>0 then
		if length(grantsStr)>0 then
			grantsStr := grantsStr||',';
		end if;
		grantsStr := grantsStr||'EXECUTE';
		if position(UPPER('b_du_chk') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_chk(sesstr character varying, sesid numeric)';
		end if;
		if position(UPPER('b_du_clear') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_clear(nameses character varying)';
		end if;
		if position(UPPER('b_du_save') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_du_save(nameses character varying)';
		end if;
		if position(UPPER('b_logncheck') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logncheck(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_lognerr_s') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognerr_s(usro varchar, usrsta varchar, usros varchar, usrip varchar, emsg varchar)';
		else
		  if position(UPPER('b_lognerr') in UPPER(TABNAME)) <> 0  then
		    TABNAME := 'FUNCTION b_lognerr(usrlo character varying, usrsta character varying, usrdom character varying, usros character varying, usrip character varying, emsg character varying)';
		  end if;
		end if;
		if position(UPPER('b_logerr') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logerr(usrlo character varying, usrsta character varying, usrdom character varying, usros character varying, usrip character varying, emsg character varying)';
		end if;
		if position(UPPER('b_lognlog') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognlog(issucc boolean, usrlo character varying)';
		end if;
		if position(UPPER('b_lognsuc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lognsuc(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_logsuc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_logsuc(usrlo character varying, usrsta character varying, usrdom character varying)';
		end if;
		if position(UPPER('b_pgrexecgrrev') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pgrexecgrrev(isgrant numeric, usrname character varying)';
		end if;
		if position(UPPER('b_pgrrevt') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pgrrevt(isgrant numeric, usrname character varying, tabname character varying, accessmask character varying, postfix character varying)';
		end if;
		if position(UPPER('b_prevgrproc') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_prevgrproc(usrname character varying)';
		end if;
		if position(UPPER('b_pwdsta') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_pwdsta(usrlo character varying, pwds timestamp without time zone)';
		end if;
		if position(UPPER('b_sec_dat_hash') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_sec_dat_hash(username character varying, pswd character varying)';
		end if;
		if position(UPPER('b_sec_dat_value') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_sec_dat_value(ids character varying)';
		end if;
		if position(UPPER('b_usr_check') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_usr_check(username character varying)';
		end if;
		if position(UPPER('b_lockuser') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_lockuser(usrlo character varying, lckflag integer)';
		end if;
		if position(UPPER('b_dltuser') in UPPER(TABNAME)) <> 0  then
		  TABNAME := 'FUNCTION b_dltuser(usrlo character varying)';
		end if;
	end if;
	if ISGRANT = 1 then
		dyn_sql := dyn_sql || 'grant '||grantsStr||' on ' || UPPER(TABNAME) || ' to "';
	else
		dyn_sql := dyn_sql || 'revoke '||grantsStr||' on '|| UPPER(TABNAME) || ' from "';
	end if;
    dyn_sql := dyn_sql || USRNAME||'"';
	--if length(POSTFIX) > 0 then
		--dyn_sql := dyn_sql || ' ';
		--dyn_sql := dyn_sql || POSTFIX;
	--end if;
	execute dyn_sql;
end;
end;
$BODY$
 LANGUAGE plpgsql SECURITY DEFINER;

update B_LAST set VER = 153;


ALTER TABLE b_OBJ 
ADD COLUMN ver integer not null default(0), 
ADD COLUMN mbsource varchar(255);

update B_LAST set VER = 154;


update B_LAST set VER = 155;


ALTER TABLE b_rds_elem_ref DROP CONSTRAINT pk_b_rds_elem_ref;

ALTER TABLE b_rds_elem_ref DROP COLUMN "KEY";

ALTER TABLE b_rds_elem_ref
  ADD CONSTRAINT pk_b_rds_elem_ref PRIMARY KEY(DICT_KEY,ELEM_KEY,REF);

ALTER TABLE b_rds_objelem_ref DROP CONSTRAINT pk_b_rds_objelem_ref;

ALTER TABLE b_rds_objelem_ref DROP COLUMN "KEY";

ALTER TABLE b_rds_objelem_ref
  ADD CONSTRAINT pk_b_rds_objelem_ref PRIMARY KEY(DICT_KEY,ELEM_KEY,REF);

update B_LAST set VER = 156;


CREATE TABLE B_OBJ_ATTR 
(
	"KEY" 		serial primary key,
	OBJ_KEY 	int not null,
	ATTR_KEY 	int not null,
	DTYPE 		int
);

create  index IX_B_OBJ_ATTR on B_OBJ_ATTR (OBJ_KEY, ATTR_KEY);

CREATE TABLE B_OBJ_ATTR_VAL_STR
(
	"KEY" 		serial primary key,
	ATTR_KEY	int not null,
 	VAL		varchar(255)
);

alter table B_OBJ_ATTR_VAL_STR
   add constraint FK_B_OBJ_ATTR_VAL_STR foreign key (ATTR_KEY)
      references B_OBJ_ATTR ("KEY") on delete cascade;

CREATE TABLE B_OBJ_ATTR_VAL_INT
(
	"KEY" 		serial primary key,
	ATTR_KEY	int not null,
 	VAL		int
);

alter table B_OBJ_ATTR_VAL_INT
   add constraint FK_B_OBJ_ATTR_VAL_INT foreign key (ATTR_KEY)
      references B_OBJ_ATTR ("KEY") on delete cascade;

CREATE TABLE B_OBJ_ATTR_VAL_FLT
(
	"KEY" 		serial primary key,
	ATTR_KEY	int not null,
 	VAL		numeric(38,30)
);

alter table B_OBJ_ATTR_VAL_FLT
   add constraint FK_B_OBJ_ATTR_VAL_FLT foreign key (ATTR_KEY)
      references B_OBJ_ATTR ("KEY") on delete cascade;

CREATE TABLE B_OBJ_ATTR_VAL_DT
(
	"KEY" 		serial primary key,
	ATTR_KEY	int not null,
 	VAL		timestamp
);

alter table B_OBJ_ATTR_VAL_DT
   add constraint FK_B_OBJ_ATTR_VAL_DT foreign key (ATTR_KEY)
      references B_OBJ_ATTR ("KEY") on delete cascade;

update B_LAST set VER = 157;



update B_LAST set VER = 158;


CREATE TABLE B_ALRT
(
  KIND      INT                           NOT NULL,
  TASK_ID   VARCHAR(127)                      NOT NULL,
  KEY_ALRT  INT                           NOT NULL,
  US_NAM    VARCHAR(127),
  US_OS     VARCHAR(127),
  US_STA    VARCHAR(127),
  OBJ_CLS   INT,
  OP_MSK    INT,
  STA       VARCHAR(127)                      NOT NULL,
  NAME      VARCHAR(127),
  OBJ_ID    VARCHAR(127),
  OP_SUC    NUMERIC(1,0),
  OBJ_KEY   INT
);

CREATE TABLE B_RALRT
(
  TASK_ID   VARCHAR(127)                      NOT NULL,
  KEY_ALRT  INT                           NOT NULL,
  STA       VARCHAR(127)                      NOT NULL
);

CREATE OR REPLACE FUNCTION TR_CHECKALERT_FUNCTION() 
RETURNS trigger 
AS
$BODY$
#variable_conflict use_variable
DECLARE
US_NAM VARCHAR(127);
US_OS    VARCHAR(127);
US_STA    VARCHAR(127);

BEGIN
    select  max(lower(a.US_NAM)), max(lower(a.US_OS)), max(lower(a.US_STA)) into US_NAM, US_OS, US_STA  
        from B_JLO a where NEW.SES = a.SES;
    
    insert into B_RALRT
        Select a.TASK_ID, a.KEY_ALRT, a.STA from B_ALRT  a
          where (a.KIND = 1)
        	and (a.OP_MSK = NEW.OP_MSK or coalesce(a.OP_MSK,-1)=-1)
        	and (a.OBJ_ID = NEW.OBJ_ID or coalesce(a.OBJ_ID,'')='') 
            and (a.US_NAM = US_NAM or coalesce(a.US_NAM,'')='') 
            and (a.US_OS = US_OS or coalesce(a.US_OS,'')='')
            and (a.US_STA = US_STA or coalesce(a.US_STA,'')='') 
            and (a.OP_SUC = NEW.OP_SUC or coalesce(a.OP_SUC,-1)=-1)
            and (a.OBJ_KEY = NEW.OBJ_KEY or coalesce(a.OBJ_KEY,-1)=-1)
            and (a.OBJ_CLS = NEW.OBJ_CLS or (a.OBJ_CLS = (NEW.OBJ_CLS & 65280)) or coalesce(a.OBJ_CLS,-1)=-1);
    return null;
END ;
$BODY$ LANGUAGE plpgsql  SECURITY DEFINER;

CREATE TRIGGER TR_CHECKALERT
AFTER INSERT ON B_JAU 
FOR EACH ROW
EXECUTE PROCEDURE TR_CHECKALERT_FUNCTION();

update B_LAST set VER = 159;


alter table B_MOD
	add SES integer not null default 0;

create index B_MOD_SES
	on B_MOD (SES);

update B_LAST set VER = 160;

alter table B_JLO
	add	US_MAC char(12);

update B_LAST set VER = 161;

alter table B_OBJ_ATTR add constraint UC_B_OBJ_ATTR unique (OBJ_KEY, ATTR_KEY);
ALTER SEQUENCE "b_obj_attr_KEY_seq" RENAME TO B_OBJ_ATTR_KEY_SEQ;
ALTER SEQUENCE "b_obj_attr_val_str_KEY_seq" RENAME TO B_OBJ_ATTR_VAL_STR_KEY_SEQ;
ALTER SEQUENCE "b_obj_attr_val_int_KEY_seq" RENAME TO B_OBJ_ATTR_VAL_INT_KEY_SEQ;
ALTER SEQUENCE "b_obj_attr_val_flt_KEY_seq" RENAME TO B_OBJ_ATTR_VAL_FLT_KEY_SEQ;
ALTER SEQUENCE "b_obj_attr_val_dt_KEY_seq" RENAME TO B_OBJ_ATTR_VAL_DT_KEY_SEQ;

update B_LAST set VER = 162;

update B_LAST set VER = 163;


