﻿// #region PP.YandexMapPlugin

(function ()
{
	var isDefined = false;

	function definePluginClass(settings)
	{
		if (isDefined)
			return;

		PP.YandexMapPlugin = function (settings)
		{
			PP.extend(settings, this._ExternalSettings, true, true);
			PP.YandexMapPlugin.base.constructor.call(this, settings);

			//Асоциативный массив геообъектов карты для отображения топоосновы. 
			//Для каждого шейпа создается своя коллекция объектов (см. GeoObjectCollection), эта коллекция хранится по идентификатору шейпа
			this._yGeoObjects = {};
			//кэш границ шейпов
			this._shapeBoundsCache = {};

			//Хэш-таблица перевода атрибутов шэйпов PP.Ui.Map в атрибуты яндекс-полигонов
			this._attrsMap = {
				'stroke': 'strokeColor',
				'stroke-opacity': 'strokeOpacity',
				'stroke-width': 'strokeWidth',
				'z-index': 'zIndex'
			};
		};

		PP.initClass(PP.YandexMapPlugin, PP.ExternalMapPlugin, 'PP.YandexMapPlugin');

		var ymp = PP.YandexMapPlugin.prototype;

		ymp._APIEnterprise = false; //Использовать коммерческую версию API Яндекс.Карты
		ymp._APIKey = null; //Ключ API, если используется коммерческая версия
		ymp._Language = null; //Локаль, с которой будет загружен Google Maps API, если не указана, используется либо текущая локаль PP, либо автоматическое определение локали исходя из местоположения и настроек браузера в зависимости от параметра UsePPLocale.
		ymp._UsePPLocale = true; //Использовать локаль PP в случае если она не указана явно в параметре Language. Если параметр равен false, используется автоматическое определение локали исходя из местоположения и настроек браузера
		ymp._Region = 'RU'; //Регион для которого нужно отображать карту. Карта будет отображаться с учетом специфики выбранного региона. Поддерживаемые регионы: RU, US, UA, TR. По-умолчанию - RU.
		ymp._APIDebugMode = false; //Если передать значение true, то API будет загружено в режиме debug
		ymp._api = null; //ссылка на загруженное API Яндекс.Карты. После загрузки API записываем его в прототип, чтобы при повторном создании экземпляра плагина не тянуть API снова.
		ymp._ExternalSettings = settings;

		ymp._initExternalAPI = function ()
		{
			if (this._api !== null)
			{
				this._onYandexMapsApiLoaded(this._api);
				return;
			}

			var ymapsUrl = this._APIEnterprise && this._APIKey ? 'https://enterprise.api-maps.yandex.ru/2.1/' : 'https://api-maps.yandex.ru/2.1/';
			var urlParams = []; //параметры запроса

			if (this._Language)
				urlParams.push('lang=' + [this._Language, this._Region].join('_'));
			else if (this._UsePPLocale)
				urlParams.push('lang=' + [PP.getCurrentCulture().CultureName, this._Region].join('_'));

			if (this._APIEnterprise && this._APIKey)
				urlParams.push('apikey=' + this._APIKey);

			if (this._APIDebugMode)
				urlParams.push('mode=debug');
			urlParams.push('ns='); //чтобы не выносить API в глобальную область видимости

			this._callbackName = Date.now().toString(); //Наименование функции колбэка, создаваемой в пространстве имен плагина. Данная функция будет выполнена после загрузки API Яндекс.Карты

			//Создаем функцию колбэк в пространстве имен плагина. Это будет ссылка на внутренний метод с привязкой контекста
			PP.YandexMapPlugin[this._callbackName] = this._onYandexMapsApiLoaded.bind(this);
			urlParams.push('onload=PP.YandexMapPlugin.' + this._callbackName);

			ymapsUrl += ('?' + urlParams.join('&'));

			PP.ScriptManager.loadScript(ymapsUrl);
		};

		ymp._onYandexMapsApiLoaded = function (ymaps)
		{
			//Сносим ссылку на колбэк из нэймспейса
			delete PP.YandexMapPlugin[this._callbackName];
			delete this._callbackName;

			//Закидываем API в прототип
			if (!this._api)
				PP.YandexMapPlugin.prototype._api = ymaps;

			this._apiReady = true;
		};

		ymp._createMap = function ()
		{
			if (!this._yMap)
			{
				//Создаем Яндекс-карту
				this._yMap = new this._api.Map(this._mapNode, {
					controls: ['zoomControl'],
					zoom: 1,
					center: this._getCenter()
				});

				//создем контэйнеры для отображения стрелок, маркеров и т.п.
				this._customPane = new this._api.pane.MovablePane(this._yMap, { zIndex: 401 });
				this._customPane.events.add('clientpixelschange', this._onCustomPaneClientPixelChanged.bind(this));

				var pElement = this._customPane.getElement(),
					svg = PP.SVG.svg();

				//Размещаем внутри пэйна холст свг
				this._customLayerNode = PP.SVG.group(svg);
				svg.style.position = 'absolute';
				pElement.appendChild(svg);

				this._yMap.panes.append('ppcustom', this._customPane);
			} else
			{
				this._yMap.geoObjects.removeAll();
				this._yGeoObjects = {};
				this._shapeBoundsCache = {};
			}

			this._isReady = true;
			this.Ready.fire(this);
		};

		ymp._onCustomPaneClientPixelChanged = function (e)
		{
			if (this._isReady)
			{
				var svg = this._customPane.getElement().firstElementChild,
					mapSize = this._yMap.container.getSize();

				svg.style.width = mapSize[0] + 'px';
				svg.style.height = mapSize[1] + 'px';
				this.Refreshed.fire(this);
			}
		};

		ymp._onPolygonMouseOver = function (shape, e)
		{
			if (!shape.isLive())
				return;

			var domEvent = e.get('domEvent');
			this.ShapeMouseOver.fire(this, { Shape: shape, Event: domEvent ? domEvent.originalEvent : null });
		};

		ymp._onPolygonMouseMove = function (shape, e)
		{
			if (!shape.isLive())
				return;

			var domEvent = e.get('domEvent');
			this.ShapeMouseMove.fire(this, { Shape: shape, Event: domEvent ? domEvent.originalEvent : null });
		};

		ymp._onPolygonMouseOut = function (shape, e)
		{
			if (!shape.isLive())
				return;

			var domEvent = e.get('domEvent');
			this.ShapeMouseOut.fire(this, { Shape: shape, Event: domEvent ? domEvent.originalEvent : null });
		};

		ymp._onPolygonMouseClick = function (shape, e)
		{
			if (!shape.isLive())
				return;

			var domEvent = e.get('domEvent');
			this.ShapeClick.fire(this, { Shape: shape, Event: domEvent ? domEvent.originalEvent : null });
		};

		ymp.setSize = function (width, height)
		{
			PP.YandexMapPlugin.base.setSize.apply(this, arguments);

			if (this._yMap)
			{
				this._yMap.container.fitToViewport();
			}
		};

		ymp.drawShape = function (shape, isVisible, isStroked, isGradient, color, opacity, borderColor, borderWidth)
		{
			if (!shape || !shape.isLive())
				return;

			var i,
				shapeId = shape.getId(),
				data = shape.getPluginData();

			if (!this._yGeoObjects[shapeId])
			{
				if (!isVisible || isStroked)
					return;

				//Создаем коллекцию геообъектов для шейпа
				var geoCollection = new this._api.GeoObjectCollection({}, {
					fill: !isStroked,
					fillColor: color,
					fillOpacity: 0.85 * opacity,
					strokeColor: borderColor,
					strokeWidth: isStroked ? borderWidth : 0,
					strokeOpacity: 0.85 * opacity,
					zIndex: data.zIndex
				});
				this._yGeoObjects[shapeId] = geoCollection;

				//привязываем события
				geoCollection.events.add('click', this._onPolygonMouseClick.bind(this, shape));
				geoCollection.events.add('mousemove', this._onPolygonMouseMove.bind(this, shape));
				geoCollection.events.add('mouseenter', this._onPolygonMouseOver.bind(this, shape));
				geoCollection.events.add('mouseleave', this._onPolygonMouseOut.bind(this, shape));

				for (i = 0; i < data.polygons.length; i++)
				{
					//Создаем полигоны и добавляем в коллекцию
					var polygon = new this._api.Polygon([data.polygons[i].slice()]);
					geoCollection.add(polygon);
				}

				//добавляем коллецию на карту
				this._yMap.geoObjects.add(geoCollection);
			} else
			{
				if (isVisible)
				{
					this._yGeoObjects[shapeId].options.set({
						fill: !isStroked,
						fillColor: color,
						fillOpacity: 0.85 * opacity,
						strokeColor: borderColor,
						strokeWidth: isStroked ? borderWidth : 0,
						strokeOpacity: 0.85 * opacity
					});
				} else
					this._yMap.geoObjects.remove(this._yGeoObjects[shapeId]);


				if (!isVisible)
				{
					delete this._yGeoObjects[shapeId];
					delete this._shapeBoundsCache[shapeId];
				}
			}
		};

		ymp.setShapeAttributes = function (shape, attributes)
		{
			if (!shape || !shape.isLive())
				return;

			var shapeId = shape.getId(),
				options = {};

			for (var i in attributes)
				options[this._attrsMap[i] || i] = attributes[i];

			this._yGeoObjects[shapeId].options.set(options);
		};

		ymp.getShapeAttributes = function (shape, attributes)
		{
			var res = {};

			if (!shape || !shape.isLive())
				return res;

			var shapeId = shape.getId();

			var geoJson = this._yGeoObjects[shapeId].options.getAll();
			return geoJson;
		};

		ymp.getShapeBoundsRect = function (shape)
		{
			var shapeId = shape && shape.isLive() ? shape.getId() : null,
				yBounds = null;

			if (shapeId)
			{
				if (this._shapeBoundsCache[shapeId])
					yBounds = this._shapeBoundsCache[shapeId];
				else if (this._yGeoObjects[shapeId])
				{
					yBounds = this._shapeBoundsCache[shapeId] = this._api.util.bounds.getCenter(this._yGeoObjects[shapeId].getBounds());
				}
			}

			return new PP.Rect({
				Left: yBounds ? yBounds[1] : 0,
				Top: yBounds ? yBounds[0] : 0,
				Width: 0,
				Height: 0
			});
		};

		ymp.geoToScreen = function (lng, lat)
		{
			/// <summary> Метод преобразования географических координат в экранные координаты. </summary>
			/// <param name="lng" type="Number"> Долгота. </param>
			/// <param name="lat" type="Number"> Широта. </param>
			/// <returns type="PP.Point"> </returns>
			var projection = this._yMap.options.get('projection');

			if (projection)
			{
				var point = projection.toGlobalPixels([lat, lng], this._yMap.getZoom());
				point = this._customPane.toClientPixels(point);
				return new PP.Point(point[0], point[1]);
			}

			return null;
		};

		ymp.getArrowLayer = ymp.getMilestoneLayer =
		ymp.getBarLayer = ymp.getPieLayer =
		ymp.getBubbleLayer = ymp.getMarkerLayer = function ()
		{
			return this._isReady ? this._customLayerNode : null;
		};

		ymp.dispose = function ()
		{
			if (this._yMap)
				this._yMap.destroy();

			PP.YandexMapPlugin.base.dispose.apply(this, arguments);
		};

		ymp = null;

		isDefined = true;
	}

	PP.Yandex = function (settings)
	{
		PP.Yandex.base.constructor.apply(this, arguments);
		this._Interfaces = [PP.IMapPlugin];
	};
	PP.initClass(PP.Yandex, PP.Object, 'PP.Yandex', [PP.IPlugin]);
	PP.Object.defineProps(PP.Yandex, ['Interfaces'], false);

	PP.Yandex.prototype._onReady = function (sender, args)
	{
		if (this._resolve)
			this._resolve();
		definePluginClass(args.Args);
		this._resolve = null;
	};

	PP.Yandex.prototype.getInstance = function ()
	{
		return { 'ResourceKey': 'eYandex', 'PPType': 'PP.YandexMapPlugin', 'TopobaseType': 'Google', 'ServiceTopobaseType': 'Google' };
	};

	PP.Yandex.prototype.ready = function (resolve, reject)
	{
		if (PP.ExternalMapPlugin)
			return true;
		this._resolve = resolve;
		return false;
	};

	PP.Yandex.init = function (settings)
	{
		if (PP.ExternalMapPlugin || !PP.ScriptManager.loadScript('ExternalMapPlugin.js', PP.Delegate(this._onReady, this, settings)))
			definePluginClass(settings);
		return new PP.Yandex;
	};
})();

// #endregion