﻿// #region PP.ExternalMapPlugin

PP.ExternalMapPlugin = function (settings)
{
	/// <summary> Абстрактный базовый класс для плагинов внешних карт</summary>

	this._TopobaseType =
	this._ServiceTopobaseType = 'Google';
	this._defineEvents([
		'Ready',
		'Error',
		'Refreshed',
		'MouseMove',
		'ShapeMouseOver',
		'ShapeMouseMove',
		'ShapeMouseOut',
		'ShapeClick',
		'ArrowMouseOver',
		'ArrowMouseMove',
		'ArrowMouseOut',
		'ArrowClick']);

	PP.ExternalMapPlugin.base.constructor.apply(this, arguments);

	//Стандартный путь к файлам топоосновы
	this._DefaultTopobaseUrl = 'Google/';
	//точки привязки топоосновы к глобальным координатам
	this._boundsPoints = null;
	//Флаг загруженности API внешних карт. Флаг выставляется после загрузки скриптов/стилей внешней карты. При этом сам объект карты может быть еще не создан.
	this._apiReady = false;
	//Флаг готовности плагина к отрисовке шейпов карты. Должен выставляться в наследниках после инициализации внешнего API, создания карты и ее компонентов и перед генерацией события Ready
	this._isReady = false;
	//Текстовый вид текущей распарсенной топоосновы
	this._currentTopoText = '';
	this._render();
	this._initExternalAPI();
};

PP.initClass(PP.ExternalMapPlugin, PP.Ui.Control, 'PP.ExteernalMapPlugin');
PP.Object.defineProps(PP.ExternalMapPlugin, ['TopobaseType', 'ServiceTopobaseType']);

var emp = PP.ExternalMapPlugin.prototype;

emp.getBarLayer = emp.getPieLayer = emp.getBubbleLayer = emp.getMarkerLayer = function ()
{
	return null;
};

emp._initExternalAPI = function ()
{
	//инициализирует внешний картографический сервис посредством загрузки необходимых скриптов
	//Метод должен только загрузить скрипты и подготовить внешнее API к работе, после чего выставить флаг _apiReady
	//Создание самого объекта карты должно выполняться в методе _createMap, после загрузки топоосновы
	//реализация должна быть выполнена в наследнике


	PP.Debug.assert(false, '_initExternalAPI not implemented');
};

emp._initExternalMap = function ()
{
	//Внутренний метод для реализации проверки готовности API и запуска создания внешней карты по таймауту

	if (PP.isDefined(this._initMapTimeout))
		return;

	if (this._apiReady)
	{
		this._createMap();
	} else
	{
		//запускаем по таймауту в ожидании инициализации API
		this._initMapTimeout = setTimeout(function ()
		{
			delete this._initMapTimeout;
			this._initExternalMap();
		}.bind(this), 50);
	}
};

emp._createMap = function ()
{
	//создает объект карты и размещает его в дом ноде плагина, после чего генерует событие выставляет флаг isReady и генерирует событие Ready

	PP.Debug.assert(false, '_createMap not implemented');
};

emp.isReady = function ()
{
	return this._isReady;
};

emp._render = function ()
{
	this._initFromHTML('<div DraggableArea="true" style="position:relative;">\
				<div style="width:100%; height:100%;"></div>\
		</div>');
	this._mapNode = this._DomNode.firstElementChild;	
	PP.ExternalMapPlugin.base._render.apply(this, arguments);
};

emp._getCenter = function ()
{
	/// <summary>Возвращает географические координаты центра карты в формате [Lat, Lng] исходя из точек привязки топоосновы. Если точки привязки не определены - возвращает [0, 0]</summary>

	if (this._boundsPoints)
	{
		var min = this._boundsPoints.min,
			max = this._boundsPoints.max;

		//если минимальная долгота больше максимальной долготы, то центр нужно высчитывать с учетом движения в восточном направлении
		return [(min.y + max.y) / 2, (min.x + max.x + (min.x > max.x ? 360 : 0)) / 2];
	} else
		return [0, 0];
};

emp._bindEvents = function ()
{
	if (this._isBind)
		return;

	PP.ExternalMapPlugin.base._bindEvents.apply(this, arguments);
	this._addEvent(this._DomNode, 'mousemove', this._onMouseMove);
};

emp._unBindEvents = function ()
{
	if (!this._isBind)
		return;

	PP.ExternalMapPlugin.base._unBindEvents.apply(this, arguments);
	this._removeEvent(this._DomNode, 'mousemove', this._onMouseMove);
};

emp._onMouseMove = function (sender, args)
{
	this.MouseMove.fire(sender, args);
};

emp.parseTopobase = function (map, text)
{
	/// <summary>Метод для парсинга топоосновы. Метод должен быть вызван внешним компонентом. После обработки топоосновы начинается процесс инициализации карты. </summary>
	/// <param name="map" type="PP.Ui.MapChart"> Объект карты, в которой будет использоваться плагин. </param>
	/// <param name="text" type="String"> Строка в формате JSON c топоосновой. </param>

	if (this._currentTopoText == text)
		return;

	this._currentTopoText = text;
	this._isReady = false;

	var res = JSON.parse(text);

	if (res.points)
		this._boundsPoints = res.points;
	else if (res.metainfo)
		this._boundsPoints = { min: res.metainfo.min, max: res.metainfo.max };

	if (map && map.isLive && map.isLive())
	{
		map.getTopobase().setMeta(PP.Ui.MapTopobaseMeta.parseFromJSON(res.metainfo));

		this._parseLayers(map, res.layers);

		//после загрузки топоосновы - создаем внешнюю карту, на которую будут отрисованы шейпы
		this._initExternalMap();
	}
};

emp._parseLayers = function (map, layers, parentLayer, layerIndex)
{
	layerIndex = layerIndex || { index: 0 };
	var mapLayers = map.getLayers();
	for (var i = 0; i < layers.length; i++)
	{
		var id = layers[i]['id'];
		var layer = map.getLayer(id) || new PP.Ui.MapLayer({ Id: id, Chart: map });

		layer.clear();

		if (parentLayer)
		{
			parentLayer.addSubLayer(layer, id);
			delete mapLayers[id];
		}
		else
			mapLayers[id] = layer;

		var shapesStyles = layers[i].shapesStyles, shapeStyle,
			oldShapes = PP.extend({}, layer.getShapes());
		if (layers[i].shapes)
		{
			var shapes = layers[i].shapes;
			for (var idShape in shapes)
			{
				delete oldShapes[idShape];

				var shape;
				if (shape = map.getShape(idShape))
					shape.clear();
				shape = layer.addShape(shape, idShape);

				//парсим набор полигонов необходимых для отрисовки шейпа				
				shape.setPluginData({
					polygons: shapes[idShape].map(function (encStr) { return this._decodePolylinePath(encStr); }.bind(this)),
					zIndex: layerIndex.index,
					styles: shapesStyles[idShape]
				});

				if (shapesStyles && (shapeStyle = shapesStyles[idShape]))
				{
					if (shapeStyle.fill)
						shape.setBackground(shapeStyle.fill);
					if (shapeStyle.stroke)
						shape.setBorderColor(shapeStyle.stroke);
					if (shapeStyle.strokeWidth)
						shape.setStrokeWidth(shapeStyle.strokeWidth);
				}

				map.removeShape(idShape);
			}
		}
		var newShapes = layer.getShapes();
		for (var j in oldShapes)
		{
			if (oldShapes[j] && oldShapes[j].dispose)
				oldShapes[j].dispose();
			delete newShapes[j];
		}
		if (layers[i].layers)
			this._parseLayers(map, layers[i].layers, layer, layerIndex);
	}
};

emp._decodePolylinePath = function (str, precission)
{
	/// <summary>Декодирует строку формата https://developers.google.com/maps/documentation/utilities/polylinealgorithm?hl=ru в набор точек lat, lng</summary>
	/// <param name="str" type="String">Закодированная строка</param>
	/// <param name="precision" type="Number" default="5">Точность возвращаемых координат</param>

	var index = 0,
        lat = 0,
        lng = 0,
        coordinates = [],
        shift = 0,
        result = 0,
        byte = null,
        latitude_change,
        longitude_change,
        factor = Math.pow(10, precission || 5);

	// Координаты имеют переменную длину, во время кодирования.
	// Поэтому просто отслеживаем где заканчивается строка.
	// В каждой итерации цикла декодируется одна пара координат
	while (index < str.length)
	{

		// Сбрасываем shift, result, byte
		byte = null;
		shift = 0;
		result = 0;

		do
		{
			byte = str.charCodeAt(index++) - 63;
			result |= (byte & 0x1f) << shift;
			shift += 5;
		} while (byte >= 0x20);

		latitude_change = ((result & 1) ? ~(result >> 1) : (result >> 1));

		shift = result = 0;

		do
		{
			byte = str.charCodeAt(index++) - 63;
			result |= (byte & 0x1f) << shift;
			shift += 5;
		} while (byte >= 0x20);

		longitude_change = ((result & 1) ? ~(result >> 1) : (result >> 1));

		lat += latitude_change;
		lng += longitude_change;

		coordinates.push([lat / factor, lng / factor]);
	}

	return coordinates;
};

emp.drawShape = function ()
{
	/// <summary> Метод отрисовки шейпа и применения основных атрибутов. Должен быть реализован в наследнике. </summary>
	/// <param name="shape" type="PP.Ui.MapShape"> Шейп. </param>
	/// <param name="isVisible" type="Boolean"> Видимость. </param>
	/// <param name="isStroked" type="Boolean"> Флаг отрисовки шейпа в виде контура. </param>
	/// <param name="isGradient" type="Boolean"> Флаг градиентной заливки шейпа. </param>
	/// <param name="color" type="String"> Цвет заливки (границы при отрисовке контуром). </param>
	/// <param name="opacity" type="Number"> Прозрачность. </param>
	/// <param name="borderColor" type="String"> Цвет границы при отрисовке не в виде контура. </param>
	/// <param name="borderWidth" type="Number"> Толщина границы. </param>

	PP.Debug.assert(false, 'drawShape not implemented');
};

emp.clearShape = function (shape)
{
	shape.setPluginData(null);
};

emp.getShapeBoundsRect = function ()
{
	return new PP.Rect({
		Left: 0,
		Top: 0,
		Width: 0,
		Height: 0
	});
};

emp.getDefaultTopobaseURL = function (fileName)
{
	/// <summary> Метод для получения пути к стандартному расположению файлов топоосновы плагина. </summary>
	/// <param name="fileName" type="String"> Имя. </param>
	/// <returns type="String"> урл топоосновы  </returns>
	return PP.isString(fileName) ? this._DefaultTopobaseUrl + fileName + '.enc.js' : this._DefaultTopobaseUrl;
}

emp.geoToScreen = function (lng, lat)
{
	return new PP.Point(0, 0);
};

emp.sceneToScreen = function (point)
{
	/// <summary> Метод преобразования координат топоосновы в экранные координаты. </summary>
	/// <param name="Point" type="PP.Point"> Точка в координатах топоосновы. </param>
	/// <returns type="PP.Point"> </returns>

	if (!point)
		return null;

	return this.geoToScreen(point.getX(), point.getY());
};

emp.getToTopobase = function (lng, lat)
{
	return new PP.Point(lng, lat);
};

emp.dispose = function ()
{
	if (this._initMapTimeout)
	{
		clearTimeout(this._initMapTimeout);
		delete this._initMapTimeout;
	}

	PP.ExternalMapPlugin.base.dispose.apply(this, arguments);
};

emp = null;

PP.ExternalMapPlugin.init = function ()
{
};

// #endregion