#!/bin/bash


CERT_DIR=./fp-certs

SERVER_CRT_NAME="fp_server.crt"
SERVER_KEY_NAME="fp_server.key"

HOSTNAME=$(hostnamectl | awk '{print $3}' | sed -n "1p")

######## DO NOT TOUCH #########
server_Crt_found=""
ca_found=""

CA_CRT_NAME="fp_ca.crt"
CA_KEY_NAME="fp_ca.key"

WEB_SERVER_HOSTNAME=""
BI_SERVER_HOSTNAME=""

web_is_present=""
bi_is_present=""

PP_SOM=""
APACHE_SERVICE_NAME=""
BI_CONFIG_PATH=""
WEB_CONFIW_PATH=""
SERVICE_TYPE=$1

function backup_file () {
  local file=$1
  local suffix=".bak"
  local n=1

  while [[ -f "$file$suffix.$n" ]]; do
    ((n++))
  done

  cp "$file" "$file$suffix.$n"
}

function find_apache_dir () {
    . /etc/os-release
    NAME=$NAME

    case "$NAME" in
        "ALT"*)
            APACHE_SERVICE_NAME="httpd2"
            PP_SOM="https://$BI_SERVER_HOSTNAME:8810/FPBI_App_v10.x/axis2/services/PP.SOM.Som"
            BI_CONFIG_PATH="/etc/httpd2-fp10.x/conf/mods-enabled/fp10.x-biserver.conf"
            WEB_CONFIW_PATH="/etc/httpd2-fp10.x-web/conf/sites-enabled/000-default.conf"
            ;;
        "Astra"*)
            APACHE_SERVICE_NAME="apache2"
            BI_CONFIG_PATH="/etc/apache2-fp10.x/mods-available/fp10.x-biserver.conf"
            local current_version=$(cat /etc/astra_version)
            if [ "$(echo -e "$current_version\n1.7.4" | sort -V | head -n1)" == "$current_version" ]; then
                BI_CONFIG_PATH="/etc/apache2-fp10.x/sites-available/000-default.conf"
            fi
            WEB_CONFIW_PATH="/etc/apache2-fp10.x-web/sites-available/webserver.conf"
            PP_SOM="https://$BI_SERVER_HOSTNAME:8810/FPBI_App_v10.x/axis2/services/PP.SOM.Som"
            ;;
        "Rocky"* | "RED"*)
            SESTATUS=$(getenforce)
            if [ $SESTATUS == "Enforcing" ];then
              echo -e "\033[31m SELINUX в статусе Enforcing, для корректной работы необходимо отключить или настроить selinux\033[0m"
              echo -e "\033[31m SELINUX в статусе Enforcing, для корректной работы необходимо отключить или настроить selinux\033[0m"
              echo -e "\033[31m SELINUX в статусе Enforcing, для корректной работы необходимо отключить или настроить selinux\033[0m"
              sleep 2
              echo -e "\033[33m Если Selinux уже настроен, игнорируйте данное сообщение \033[0m"
              read -p "Вы хотите продолжить? (Y/n) " action
              if [[ "$action" == [Yy] ]]; then
                  echo "Продолжение установки....."
              else
                  echo "Отменено пользователем"
                  exit
              fi
            fi
            APACHE_SERVICE_NAME="httpd"
            BI_CONFIG_PATH="/etc/httpd-fp10.x/conf.d/fp10.x-biserver.conf"
            WEB_CONFIW_PATH="/etc/httpd-fp10.x-web/conf.d/00-virtualhost.conf"
            PP_SOM="https://$BI_SERVER_HOSTNAME:8810/FPBI_App_v10.x/axis2/services/PP.SOM.Som"
            ;;

    esac


}

function change_web_settings () {

    ######## функция бэкапа PP.xml и config.json ####
    backup_file "/opt/foresight/fp10.x-webserver/r/config/config.json"
    backup_file "/opt/foresight/fp10.x-webserver/config/PP.xml"

    sed -i 's/"withCredentials" *[^,}]*/"withCredentials": '\"true\"'/g' /opt/foresight/fp10.x-webserver/r/config/config.json

    sed -i 's|withCredentials *= *".*"|withCredentials="true"|g' /opt/foresight/fp10.x-webserver/config/PP.xml
    # если в конфиге присутствуют и http и https ссылки
    sed -i 's/http:/https:/g' /opt/foresight/fp10.x-webserver/r/config/config.json
    sed -i 's/http:/https:/g' /opt/foresight/fp10.x-webserver/config/PP.xml
    sed -i 's|https://[^/]*|https://'$WEB_SERVER_HOSTNAME':8110|g' /opt/foresight/fp10.x-webserver/config/PP.xml
    sed -i 's|https://[^/]*|https://'$WEB_SERVER_HOSTNAME':8110|g' /opt/foresight/fp10.x-webserver/r/config/config.json



    if [ "$SERVICE_TYPE" == "service" ]; then
      echo " Настройка как сервис "
      sed -i 's|"serviceUrl" *: .*"|"serviceUrl": '\"$PP_SOM\"'|g' /opt/foresight/fp10.x-webserver/r/config/config.json
      sed -i -r 's|(proxy\|service) *url *= *"[^"]*"|service url='\"$PP_SOM\"'|' /opt/foresight/fp10.x-webserver/config/PP.xml
    else
      sed -i 's|"serviceUrl" *: .*"|"serviceUrl": "https://'$WEB_SERVER_HOSTNAME':8110/fp10.x/app/PPService.axd"|g' /opt/foresight/fp10.x-webserver/r/config/config.json
      sed -i -r 's|(proxy\|service) *url *= *"[^"]*"|proxy url="" |' /opt/foresight/fp10.x-webserver/config/PP.xml
    fi
    if [[ $bi_is_present == 'true' ]]; then
      backup_file "/opt/foresight/fp10.x-biserver/etc/settings.xml"
      sed -i 's/SecureSession *= *"[^"]*"/SecureSession="1"/' /opt/foresight/fp10.x-biserver/etc/settings.xml
    fi
    backup_file "/etc/opt/foresight/fp10.x-webserver/envvars"
    sed -i 's|PP_SOM=.*|PP_SOM='$PP_SOM'|g' /etc/opt/foresight/fp10.x-webserver/envvars
}

function change_apache_configs () {
  if [[ $bi_is_present == "true" ]]; then
    backup_file "$BI_CONFIG_PATH"

    sed -i '/<\/Location>/q' $BI_CONFIG_PATH

    sudo bash -c 'cat << EOF >> '$BI_CONFIG_PATH'
<VirtualHost *:8810>
SSLEngine on
SSLCertificateFile /opt/foresight/ssl/'$SERVER_CRT_NAME'
SSLCertificateKeyFile /opt/foresight/ssl/'$SERVER_KEY_NAME'


        RewriteEngine On
        RewriteCond %{REQUEST_METHOD} OPTIONS
        RewriteRule ^(.*)$ \$1 [R=200,L]

<IfModule mod_headers.c>
Header always set Access-Control-Allow-Origin "https://'$WEB_SERVER_HOSTNAME':8110"
Header always set Access-Control-Allow-Credentials true
Header always set Access-Control-Allow-Methods "POST, GET, OPTIONS, DELETE, PUT"
Header always set Access-Control-Allow-Headers "append,delete,entries,foreach,get,has,keys,set,values,authorization,origin,content-type,get-ppbi-time,accept-language,cache-control,soapaction"
</IfModule>
</VirtualHost>
EOF'
  fi

if [[ $web_is_present == "true" ]]; then
  backup_file $WEB_CONFIW_PATH
  sed -ie '/<VirtualHost \*:8110>/a \
  SSLEngine on\
  SSLCertificateFile /opt/foresight/ssl/'$SERVER_CRT_NAME'\
  SSLCertificateKeyFile /opt/foresight/ssl/'$SERVER_KEY_NAME'\
  \
  SSLProxyEngine on' $WEB_CONFIW_PATH
fi

case $APACHE_SERVICE_NAME in
    'apache2') # Для астры

        if [[ $bi_is_present == "true" ]]; then
          a2enmod-fp10.x ssl
          sed -ie 's/Listen 443/#Listen 443/g' /etc/$APACHE_SERVICE_NAME-fp10.x/ports.conf
          systemctl restart $APACHE_SERVICE_NAME-fp10.x
        fi
        if [[ $web_is_present == "true" ]]; then
          a2enmod-fp10.x-web ssl
          sed -ie 's/Listen 443/#Listen 443/g' /etc/$APACHE_SERVICE_NAME-fp10.x-web/ports.conf
          systemctl restart $APACHE_SERVICE_NAME-fp10.x-web
        fi
        ;;
    'httpd') # Для Рокки и РедОс
        # Пропускаем, там нечего комментировать
        dnf install -y mod_ssl
        if [ $? -ne 0 ]; then
            echo -e "\033[31m Ошибка установки mod_ssl\033[0m"
            exit
        fi

        if [[ $bi_is_present == "true" ]]; then
          cp /etc/httpd/conf.modules.d/00-ssl.conf /etc/httpd-fp10.x/conf.modules.d/
          systemctl restart $APACHE_SERVICE_NAME-fp10.x
        fi
        if [[ $web_is_present == "true" ]]; then
         cp /etc/httpd/conf.modules.d/00-ssl.conf /etc/httpd-fp10.x-web/conf.modules.d/
         systemctl restart $APACHE_SERVICE_NAME-fp10.x-web
        fi
        ;;
    'httpd2') # Для Альта
        apt-get install -y apache2-mod_ssl
        if [ $? -ne 0 ]; then
            echo -e "\033[31m Ошибка установки apache2-mod_ssl\033[0m"
            exit
        fi

        if [[ $bi_is_present == "true" ]]; then
          sed -ie 's/Listen 443/#Listen 443/g' /etc/$APACHE_SERVICE_NAME-fp10.x/conf/ports-available/https.conf
          cp /etc/httpd2/conf/mods-available/ssl.load /etc/httpd2-fp10.x/conf/mods-available/
          /usr/sbin/a2enmod-fp10.x ssl

          /usr/sbin/a2enmod-fp10.x rewrite
          /usr/sbin/a2enmod-fp10.x headers
          if [ $? -ne 0 ]; then
              echo -e "\033[31m Ошибка запуска модуля ssl a2enmod-fp10.x ssl\033[0m"
              exit
          fi

          systemctl restart $APACHE_SERVICE_NAME-fp10.x
        fi
        if [[ $web_is_present == "true" ]]; then
        sed -ie 's/Listen 443/#Listen 443/g' /etc/$APACHE_SERVICE_NAME-fp10.x-web/conf/ports-available/https.conf
        cp /etc/httpd2/conf/mods-available/ssl.load /etc/httpd2-fp10.x-web/conf/mods-available/
         /usr/sbin/a2enmod-fp10.x-web ssl
         if [ $? -ne 0 ]; then
              echo -e "\033[31m Ошибка запуска модуля ssl a2enmod-fp10.x ssl\033[0m"
              exit
          fi

         systemctl restart $APACHE_SERVICE_NAME-fp10.x-web
        fi
        ;;
esac
        if [ $? -ne 0 ]; then
            echo -e "\033[31m Ошибка при запуске сервиса $APACHE_SERVICE_NAME-fp10.x\033[0m"
            sleep 2
            exit
        fi
}

function check_cert_in_folder() {
if [ -f "$CERT_DIR/$SERVER_CRT_NAME" ]; then
    if [ -f "$CERT_DIR/$SERVER_KEY_NAME" ]; then
      server_found=true
    else
        echo -e "\033[31mнайден $SERVER_CRT_NAME но нехватает $SERVER_KEY_NAME дальнейшее выполнение невозможно\033[0m"
        exit 1
    fi
else
  server_found=false
fi

if [ !"$server_found" ]; then
  echo -e "\033[31mСертификат $SERVER_CRT_NAME не найден в папке $CERT_DIR.\033[0m"
  read -p "Если вы желаете сгенерировать самоподписанный сертификат для сервера, то нажмите клавишу Y. Нажмите любую другую клавишу для прекращения работы скрипта: " choice

  # Проверяем ввод пользователя
  if [[ "$choice" =~ ^[Yy]$ ]]; then
    self_signed=true
  else
    echo -e "\033[31mРабота скрипта прекращена пользователем.\033[0m"
    exit 1
  fi
fi

}


function create_certs(){
  if [ ! -d $CERT_DIR ]; then
    mkdir -p $CERT_DIR
    chmod 750 $CERT_DIR
  fi
    cd $CERT_DIR

  if [ $server_found == "false" ]; then
    if [[ $self_signed == "true" ]]; then
      echo " выпускаем ca"
      openssl genpkey -algorithm RSA -out $CA_KEY_NAME
      openssl req -x509 -new -nodes -key $CA_KEY_NAME -sha256 -days 1024 -out $CA_CRT_NAME -subj "/CN=*$HOSTNAME"
    fi
    echo "выпускаем server.crt"
    openssl genpkey -algorithm RSA -out $SERVER_KEY_NAME
    openssl req -new -key $SERVER_KEY_NAME -out fp_server.csr -subj "/CN=$HOSTNAME"
    openssl x509 -req -in fp_server.csr -CA $CA_CRT_NAME -CAkey $CA_KEY_NAME -CAcreateserial -out $SERVER_CRT_NAME -days 1024 -sha256
  fi

  if [ ! -d "/opt/foresight/ssl" ]; then
    mkdir -p /opt/foresight/ssl/
    chmod 750 /opt/foresight/ssl
  fi

  cp --backup=numbered --suffix=".bak" $SERVER_KEY_NAME $SERVER_CRT_NAME /opt/foresight/ssl/
  chmod 644 /opt/foresight/ssl/*$SERVER_CRT_NAME*
  chmod 600 /opt/foresight/ssl/*$SERVER_KEY_NAME*

  if [ -f fp_server.csr ]; then
    rm fp_server.csr
  fi

  cd -
}

function change_dba_config () {
    if [ -d "/opt/foresight/dba" ] && [ -f "/opt/foresight/dba/10.x/config/DBA.config.json" ]; then
      if ! systemctl list-units --type=service --state=loaded | grep -q fp10.x-dba; then
        sed -ie 's/"withCredentials" *[^,}]*/"withCredentials": '\"true\"'/g' /opt/foresight/dba/10.x/config/DBA.config.json
        sed -i 's|"ppServiceUrl" *: .*"|"ppServiceUrl": '\"$PP_SOM\"'|g' /opt/foresight/dba/10.x/config/DBA.config.json
        sed -i 's/http:/https:/g' /opt/foresight/dba/10.x/config/DBA.config.json
      fi
    fi
}

#Проверка прав пользователя
if [ "$EUID" -ne 0 ]; then
  echo -e "\033[31mДля запуска скрипта требуются права суперпользователя\033[0m"
  exit
fi
if ! which sudo > /dev/null 2>&1; then
    echo -e "\033[31m Для корректного выполнения скрипта нужно установить sudo \033[0m"
    exit 1
fi
if ! sudo ls > /dev/null 2>&1; then
    echo "Пользователь $(whoami) не может использовать sudo."
    exit 1
fi
## Поиск установленной платформы
if [[ ! -d "/opt/foresight/fp10.x-webserver" ]] && [[ ! -d "/opt/foresight/fp10.x-biserver" ]]; then
    echo -e "\033[33m Неудалось обнаружить веб и bi сервера, установка прервана \033[0m"
    exit 1
fi
if [[ ! $HOSTNAME == *.* ]]; then
  echo -e "\033[33m Для корректной работы и отображения веб-приложения в разных браузерах,\033[0m"
  echo -e "\033[33m рекомендуем изменить hostname сервера с указанием доменного имени,\033[0m"
  echo -e "\033[33m напр. webapp.local или webapp.domain.local\033[0m"
  read -p "Вы хотите продолжить? (Y/n) " continue
  if [[ "$continue" == [Yy] ]]; then
      echo "Продолжение установки....."
  else
      echo "Отменено пользователем"
      exit
  fi
fi

## Проверка установлен ли web
if [[ ! -d "/opt/foresight/fp10.x-webserver" ]]; then
    echo -e "\033[33m Веб сервер не обнаружен \033[0m"
    echo -e "\033[33m Для дальнейшей настройки \033[0m"
    echo -e "\033[33m Ведите ИМЯ сервера веб-приложения (или N для отмены): \033[0m"
    read continue
    if [[ "$continue" == [Nn] ]]; then
        echo "Отменено пользователем"
        exit 0
    else
        WEB_SERVER_HOSTNAME="$continue"
        web_is_present="false"
        echo -e "\033[32m Установлено имя веб-сервера ... $WEB_SERVER_HOSTNAME \033[0m"
        echo "Продолжение установки....."
        sleep 2
    fi
fi
## Проверка установлен ли bi
if [[ ! -d "/opt/foresight/fp10.x-biserver/" ]]; then
    echo -e "\033[33m Bi сервер не обнаружен \033[0m"
    echo -e "\033[33m Для дальнейшей настройки \033[0m"
    echo -e "\033[33m Ведите ИМЯ сервера Bi (или N для отмены): \033[0m"
    read continue
    if [[ "$continue" == [Nn] ]]; then
        exit 0
    else
        BI_SERVER_HOSTNAME="$continue"
        bi_is_present="false"
        echo -e "\033[32m Установлено имя bi-сервера ... $BI_SERVER_HOSTNAME \033[0m"
        echo "Продолжение установки....."
        sleep 2
    fi
fi
## Назначаем переменные с именем если оба инстанса веб и bi на одном сервере.
if [[ $BI_SERVER_HOSTNAME == "" ]]; then
    BI_SERVER_HOSTNAME="$HOSTNAME"
    bi_is_present="true"
fi
if [[ $WEB_SERVER_HOSTNAME == "" ]]; then
    WEB_SERVER_HOSTNAME="$HOSTNAME"
    web_is_present="true"
fi
check_cert_in_folder
find_apache_dir
create_certs
if [[ $web_is_present == "true" ]]; then
  change_web_settings
fi
change_apache_configs
change_dba_config

echo -e "\033[32m Настройка https завершена \033[0m"