﻿// #region BingMapPlugin

(function ()
{
	var isDefined = false;

	function definePluginClass(settings)
	{
		if (isDefined)
			return;

		PP.BingMapPlugin = function (settings)
		{
			PP.extend(settings, this._ExternalSettings, true, true);
			PP.BingMapPlugin.base.constructor.call(this, settings);

			//Хэш объектов класса Microsoft.Maps.EntityCollection, хранящихся по идентификатору шейпа. Коллекции хранят набор полигонов для шейпа.
			this._bPolyCollections = {};
			//Кэш вычисленных границ шейпов
			this._shapeBoundsCache = {};
		};

		PP.initClass(PP.BingMapPlugin, PP.ExternalMapPlugin, 'PP.BingMapPlugin');

		var bmp = PP.BingMapPlugin.prototype;

		bmp._APIKey = null; //Ключ API Microsoft Bing Maps
		bmp._ExternalSettings = settings;

		bmp._render = function ()
		{
			//размещать карту нужно в ифрэйме с целью исключения конфликта имен
			this._initFromHTML('<div DraggableArea="true" style="position:relative;">\
				<iframe src="about:blank" style="width:100%; height:100%; border: none; padding: 0px; margin: 0px;"></iframe>\
		</div>');

			this._domReady = new Promise(function (resolve, reject)
			{
				this._DomNode.firstElementChild.onload = resolve;
			}.bind(this));

			this._domReady.then(function ()
			{
				this._frameContext = this._DomNode.firstElementChild.contentWindow;
				this._mapNode = this._frameContext.document.body;
				this._scriptsNode = this._frameContext.document.head;

				this._mapNode.setAttribute('style', 'width: 100%; height: 100%; padding: 0px; margin: 0px;');
			}.bind(this));
		};

		bmp._initExternalAPI = function ()
		{
			this._domReady.then(function ()
			{
				var bmapsUrl = 'http://www.bing.com/api/maps/mapcontrol?callback=PPBingMapPluginonGetAPI';

				//Bing умеет запускать колбэк только из глобальной области видимости
				this._frameContext.PPBingMapPluginonGetAPI = this._onBingMapsApiLoaded.bind(this);

				PP.ScriptManager.current.setParentNode(this._scriptsNode);
				if (!PP.ScriptManager.loadScript(bmapsUrl, null, null, 'bingApi'))
					this._onBingMapsApiLoaded();
				PP.ScriptManager.current.setParentNode(null);
			}.bind(this));
		};

		bmp._onBingMapsApiLoaded = function ()
		{
			delete this._frameContext.PPBingMapPluginonGetAPI;
			this._api = this._frameContext.Microsoft.Maps;
			this._apiReady = true;
		};

		bmp._createMap = function ()
		{
			if (!this._bMap)
			{
				var center = this._getCenter();

				center = new this._api.Location(center[0], center[1]);

				this._bMap = new this._api.Map(this._mapNode, {
					credentials: this._APIKey,
					showLocateMeButton: false,
					showMapTypeSelector: false,
					showTrafficButton: false,
					center: center,
					zoom: 2
				});

				//Подписываемся на событие перемещение мыши. Нужно будет прокидывать наверх событие перемещение над шейпом, 
				//т.к. у полигонов в Bing нет собственного события mousemove
				this._api.Events.addHandler(this._bMap, 'mousemove', this._onMapMouseMove.bind(this));
				this._api.Events.addHandler(this._bMap, 'mouseout', this._onMapMouseOut.bind(this));

				//Создаем пользовательский оверлэй для рисвания стрелок, графиков, маркеров и т.п.
				this._customOverlay = this._createCustomOverlay();
				this._bMap.layers.insert(this._customOverlay);
				this._api.Events.addHandler(this._bMap, 'viewchange', this._onMapViewChange.bind(this));
			} else
			{
				//нужно похерить все отрисованные полигоны на карте
				this._bMap.entities.clear();
				this._bPolyCollections = {};

				this._isReady = true;
				this.Ready.fire(this);
			}
		};

		bmp._createCustomOverlay = function ()
		{
			var node = PP.SVG.svg();
			node.style.position = 'absolute';
			node.style.width = this._bMap.getWidth() + 'px';
			node.style.height = this._bMap.getHeight() + 'px';
			PP.SVG.group(node);

			//создаем класс наследник Microsoft.Maps.CustomOverlay
			var CustomOverlay = function (container)
			{
				this.container = container;
			};
			CustomOverlay.prototype = new this._api.CustomOverlay();
			CustomOverlay.prototype.onAdd = function ()
			{
				this.setHtmlElement(this.container);
			};
			CustomOverlay.prototype.onLoad = function ()
			{
				this._customOverlay.container.style.width = this._bMap.getWidth() + 'px';
				this._customOverlay.container.style.height = this._bMap.getHeight() + 'px';

				this._isReady = true;
				this.Ready.fire(this);
			}.bind(this);

			return new CustomOverlay(node);
		};

		bmp._onMapMouseMove = function (e)
		{
			if (this._mouseOverShape && this._mouseOverShape.isLive())
				this.ShapeMouseMove.fire(this, { Shape: this._mouseOverShape, Event: this._fixEvent(e) });
		};

		bmp._onMapMouseOut = function (e)
		{
			if (this._mouseOverShape && this._mouseOverShape.isLive())
			{
				this.ShapeMouseOut(this, { Shape: this._mouseOverShape, Event: this._fixEvent(e) });
				delete this._mouseOverShape;
			}
		};

		bmp._onMapViewChange = function ()
		{
			this._customOverlay.container.style.width = this._bMap.getWidth() + 'px';
			this._customOverlay.container.style.height = this._bMap.getHeight() + 'px';

			if (this._isReady)
				this.Refreshed.fire(this);
		};

		bmp.setSize = function (width, height)
		{
			PP.BingMapPlugin.base.setSize.apply(this, arguments);

			setTimeout(function ()
			{
				if (this._customOverlay)
				{
					this._customOverlay.container.style.width = this._bMap.getWidth() + 'px';
					this._customOverlay.container.style.height = this._bMap.getHeight() + 'px';
				}

				if (this._isReady)
					this.Refreshed.fire(this);
			}.bind(this), 200);
		};

		bmp.drawShape = function (shape, isVisible, isStroked, isGradient, color, opacity, borderColor, borderWidth)
		{
			if (!this._isReady || !shape || !shape.isLive())
				return;

			var shapeId = shape.getId(),
				data = shape.getPluginData(),
				mFillColor = null,
				mBorderColor = null,
				i;

			if (!this._bPolyCollections[shapeId])
			{
				if (!isVisible || isStroked)
					return;

				this._bPolyCollections[shapeId] = new this._api.EntityCollection({ zIndex: data.zIndex });
				var normPolygons = this._normalisePolygons(data.polygons);

				for (i = 0; i < normPolygons.length; i++)
				{
					//Массив с точками геометрии полигона надо создавать в контексте фрэйма, иначе при передаче во фрейм он не определяется как массив(instanceof) и код Bing'a падает
					var geom = (new this._frameContext.Array()).concat(normPolygons[i]),
						polygon = null;

					//1. Цвет границы
					mBorderColor = this._api.Color.fromHex(borderColor);
					//2. Цвет заливки
					mFillColor = this._api.Color.fromHex(color);
					mFillColor.a = isStroked ? 0 : 0.85 * opacity;

					//3. Создаем полигон
					polygon = new this._api.Polygon(geom, {
						fillColor: mFillColor,
						strokeColor: isStroked && borderColor ? mBorderColor : undefined,
						strokeThickness: isStroked && borderColor ? borderWidth : 0
					});
					this._bindPolygonEventsListeners(polygon, shape);

					//4. Помещаем полигон в коллекцию для данного шейпа
					this._bPolyCollections[shapeId].push(polygon);
				}

				//5. Помещаем коллекцию полигонов шейпа на карту
				this._bMap.entities.push(this._bPolyCollections[shapeId]);
			} else
			{
				if (!isVisible)
				{
					this._bMap.entities.remove(this._bPolyCollections[shapeId]);
					delete this._bPolyCollections[shapeId];
				} else
				{
					var options = {};

					mBorderColor = this._api.Color.fromHex(borderColor);

					mFillColor = this._api.Color.fromHex(color);
					mFillColor.a = 0.85 * opacity;

					options.fillColor = !isStroked ? mFillColor : 'none';
					options.strokeColor = isStroked && borderColor ? mBorderColor : null;
					options.strokeThickness = isStroked && borderColor ? borderWidth : 0;

					for (i = 0; i < this._bPolyCollections[shapeId].getLength() ; i++)
						this._bPolyCollections[shapeId].get(i).setOptions(options);
				}
			}
		};

		bmp._normalisePolygons = function (polygons)
		{
			var res = [];

			for (var i = 0; i < polygons.length; i++)
			{
				var points = polygons[i].map(function (latlng)
				{
					//генерим M$ классы для точек
					return new this._api.Location(latlng[0], latlng[1]);
				}.bind(this));

				var separatePolygons = [],
					sepPoints = null;

				for (var j = 0; j < points.length; j++)
				{
					var p1 = points[j],
						p2 = j < points.length - 1 ? points[j + 1] : p1;

					if (Math.abs(p1.longitude - p2.longitude) > 180)
					{
						//разделяем полигон, выделяем часть которая лежит в другом полушарии
						if (!sepPoints)
							sepPoints = [];

						sepPoints.push(p2);
						points.splice(j + 1, 1);
						j--;
					} else if (sepPoints)
					{
						separatePolygons.push(sepPoints);
						sepPoints = null;
					}
				}
				if (sepPoints)
					res.push(sepPoints);
				res.push(points);
				res = res.concat(separatePolygons);
			}

			return res;
		};

		bmp._bindPolygonEventsListeners = function (polygon, shape)
		{
			this._api.Events.addHandler(polygon, 'mouseover', this._onPolygonMouseOver.bind(this, shape));
			this._api.Events.addHandler(polygon, 'mouseout', this._onPolygonMouseOut.bind(this, shape));
			this._api.Events.addHandler(polygon, 'click', this._onPolygonMouseClick.bind(this, shape));
		};

		bmp._fixEvent = function (e)
		{
			//т.к. карта находится в iframe координаты pageX и pageY эвента приходят относительно фрейма
			//прибавим к ним смещение left, top ноды плагина

		    var res = {
		        originalEvent: e
		    },
				domNodeRect = this._DomNode.getBoundingClientRect();

		    for (var p in e) {
		        res[p] = e[p];
		    }

		    res.pageX += domNodeRect.left;
		    res.pageY += domNodeRect.top;

		    return res;
		};

		bmp._onPolygonMouseOver = function (shape, e)
		{
			if (!shape || !shape.isLive())
				return;

			this._mouseOverShape = shape;
			this.ShapeMouseOver.fire(this, { Shape: shape, Event: this._fixEvent(e) });
		};

		bmp._onPolygonMouseOut = function (shape, e)
		{
			if (!shape || !shape.isLive())
				return;

			delete this._mouseOverShape;
			this.ShapeMouseOut.fire(this, { Shape: shape, Event: this._fixEvent(e) });
		};

		bmp._onPolygonMouseClick = function (shape, e)
		{
			if (!shape || !shape.isLive())
				return;

			this.ShapeClick.fire(this, { Shape: shape, Event: this._fixEvent(e) });
		};

		bmp.getShapeBoundsRect = function (shape)
		{
			/// <summary> Метод получения границ шейпа. </summary>
			/// <returns type="PP.Rect"> Границы. </returns>

			var shapeId = shape && shape.isLive() ? shape.getId() : null,
				bLocRect = null;

			if (shapeId != null)
			{
				if (this._shapeBoundsCache[shapeId])
					bLocRect = this._shapeBoundsCache[shapeId];
				else if (this._bPolyCollections[shapeId])
				{
					var locations = [];
					this._bPolyCollections[shapeId].getPrimitives().forEach(function (p)
					{
						locations = locations.concat(p.getLocations());
					});

					this._shapeBoundsCache[shapeId] = bLocRect = this._api.LocationRect.fromLocations(locations);
				}
			}

			return new PP.Rect({
				Left: bLocRect ? bLocRect.center.longitude : 0,
				Top: bLocRect ? bLocRect.center.latitude : 0,
				Width: 0,
				Height: 0
			});
		};

		bmp.geoToScreen = function (lng, lat)
		{
			if (this._isReady)
			{
				var location = new this._api.Location(lat, lng),
					point = this._bMap.tryLocationToPixel(location, this._api.PixelReference.control);

				return point ? new PP.Point(point.x, point.y) : null;
			}

			return null;
		};

		bmp.getArrowLayer = bmp.getMilestoneLayer =
		bmp.getBarLayer = bmp.getPieLayer =
		bmp.getBubbleLayer = bmp.getMarkerLayer = function ()
		{
			return this._isReady ? this._customOverlay.container : null;
		};

		bmp.dispose = function ()
		{
			this._mouseOverShape = null;
			if (this._bMap)
				this._bMap.dispose();

			PP.BingMapPlugin.base.dispose.apply(this, arguments);
		};

		bmp = null;

		isDefined = true;
	}

	PP.Bing = function (settings)
	{
		PP.Bing.base.constructor.apply(this, arguments);
		this._Interfaces = [PP.IMapPlugin];
	};
	PP.initClass(PP.Bing, PP.Object, 'PP.Bing', [PP.IPlugin]);
	PP.Object.defineProps(PP.Bing, ['Interfaces'], false);

	PP.Bing.prototype._onReady = function (sender, args)
	{
		if (this._resolve)
			PP.Delegate.fire(this._resolve, this);
		definePluginClass(args.Args);
		this._resolve = null;
	};

	PP.Bing.prototype.getInstance = function ()
	{
		return { 'ResourceKey': 'eBing', 'PPType': 'PP.BingMapPlugin', 'TopobaseType': 'Google', 'ServiceTopobaseType': 'Google' };
	};

	PP.Bing.prototype.ready = function (resolve, reject)
	{
		if (PP.ExternalMapPlugin)
			return true;
		this._resolve = resolve;
		return false;
	};

	PP.Bing.init = function (settings)
	{
		var bing = new PP.Bing;
		/** Задайте относительный путь до плагина ExternalMapPlugin.js, аналогичный пути к JS-файлу плагина в конфигурационном файле */
		if (PP.ExternalMapPlugin || !PP.ScriptManager.loadScript('../Plugins/Map/ExternalMapPlugin.js', new PP.Delegate(bing._onReady, bing, settings)))
			definePluginClass(settings);
		return bing;
	};
})();

// #endregion