# postgres credentials
export PGUSERNAME=postgres
export PGPASSWORD=$PGUSERNAME
# create database
export SERVER=localhost
export PORT=5432
export DBNAME=NEW_DATABASE
# create database role
export DBROLE=NEW_USER
# set password for created role
export DBPASSWORD=NEW_USER
# set repository id
export REPOSITORY_ID=$DBNAME
# work directory
export RM_WORKDIR=/opt/foresight/fp10.x-biserver/bin
export RM_FILE=/opt/foresight/fp10.x-biserver/bin/rm/current.rm4
# service user credentials
export SUSERNAME=SERVICE_USER
export SUSERPASSWORD=$SUSERNAME
export DRIVER_ID=POSTGRES
#psql patterns
PSQL0="psql --host=$SERVER --port $PORT --username $PGUSERNAME --dbname postgres"
PSQL1="psql --host=$SERVER --port $PORT --username $PGUSERNAME --dbname $DBNAME"

echo "Step 1: Creating Database"
$PSQL0 -c "\\x" -c "CREATE ROLE \"${DBROLE}\" LOGIN ENCRYPTED PASSWORD '${DBPASSWORD}' NOSUPERUSER INHERIT NOCREATEDB NOCREATEROLE NOREPLICATION;";
$PSQL0 -c "\\x" -c "CREATE DATABASE \"${DBNAME}\" WITH OWNER = \"${DBROLE}\" ENCODING = 'UTF8' TABLESPACE = pg_default  LC_COLLATE = default LC_CTYPE = default CONNECTION LIMIT = -1;";
$PSQL0 -c "\\x" -c "ALTER DATABASE \"${DBNAME}\" SET lo_compat_privileges = 'on';";
$PSQL0 -c "\\x" -c "GRANT ALL ON DATABASE \"${DBNAME}\" TO \"${DBROLE}\";";
$PSQL1 -c "\\x" -c "CREATE FUNCTION loin (cstring) RETURNS lo AS 'oidin' LANGUAGE internal IMMUTABLE STRICT;";
$PSQL1 -c "\\x" -c "CREATE FUNCTION loout (lo) RETURNS cstring AS 'oidout' LANGUAGE internal IMMUTABLE STRICT;";
$PSQL1 -c "\\x" -c "CREATE FUNCTION lorecv (internal) RETURNS lo AS 'oidrecv' LANGUAGE internal IMMUTABLE STRICT;";
$PSQL1 -c "\\x" -c "CREATE FUNCTION losend (lo) RETURNS bytea AS 'oidsend' LANGUAGE internal IMMUTABLE STRICT;";
$PSQL1 -c "\\x" -c "CREATE TYPE lo ( INPUT = loin, OUTPUT = loout, RECEIVE = lorecv, SEND = losend, INTERNALLENGTH = 4, PASSEDBYVALUE );";
$PSQL1 -c "\\x" -c "CREATE CAST (lo AS oid) WITHOUT FUNCTION AS IMPLICIT;";
$PSQL1 -c "\\x" -c "CREATE CAST (oid AS lo) WITHOUT FUNCTION AS IMPLICIT;";
$PSQL1 -c "\\x" -c "CREATE OR REPLACE FUNCTION lo_manage() RETURNS pg_catalog.trigger AS '\$libdir/lo' LANGUAGE C;";

echo "Step 2: Creating Metabase"
cd $RM_WORKDIR
sudo ./RepoManager_start.sh -ocreate-repo -tpostgres -s$SERVER -p$PORT -u$DBROLE -w$DBPASSWORD -d$DBNAME -f$RM_FILE -i

echo "Step 3: Creating service user"
sudo ./PP.Util_start.sh /create_audit_user $REPOSITORY_ID $DBNAME $DBPASSWORD $SUSERNAME $SUSERPASSWORD

echo "Step 4: Saving service user credentials"
sudo ./PP.Util_start.sh /save_audit_creds "$SERVER|$DRIVER_ID" $SUSERNAME $SUSERPASSWORD