#!/bin/bash

set -e

DOCKER_COMPOSE_DIRECTORY_PATH="${1:-${DOCKER_COMPOSE_DIRECTORY_PATH:-$(pwd)}}"
NEED_UPDATE_POSTGRES_LOCAL_HOST="${2:-${NEED_UPDATE_POSTGRES_LOCAL_HOST:-False}}"
COMPOSE_PROJECT_NAME="${3:-${COMPOSE_PROJECT_NAME:-fmp}}"

if [ ${NEED_UPDATE_POSTGRES_LOCAL_HOST} = "True" ]; then
  echo "Обновление значение хоста для локальных БД"
  POSTGRES_LOCAL_USERNAME="${4:-${POSTGRES_LOCAL_USERNAME:-hhive}}"
  POSTGRES_LOCAL_NAME="${5:-${POSTGRES_LOCAL_NAME:-hhive}}"
  NEW_LOCAL_HOST="${6:-${NEW_LOCAL_HOST:-hhive}}"

  MAIN_DB_CONTAINER_NAME=$(docker ps --format "{{.Names}}" | grep "main_db")
  UPDATE_COMMAND="UPDATE dashboard_datasourcepostgres SET host='${NEW_LOCAL_HOST}' WHERE id in (SELECT dashboard_datasourcepostgres.id from dashboard_datasourcepostgres INNER JOIN dashboard_datasourcelocalpostgres ON dashboard_datasourcepostgres.id=dashboard_datasourcelocalpostgres.datasourcepostgres_ptr_id);"

  docker exec -ti ${MAIN_DB_CONTAINER_NAME} psql -U ${POSTGRES_LOCAL_USERNAME} ${POSTGRES_LOCAL_NAME} --command "${UPDATE_COMMAND}"
  echo "Обновление значение хоста для локальных БД закончилось"
fi

# Объявление директории, где необходимо размещать файлы бэкапа
DATA_FOLDER=$(cd "$(dirname "${BASH_SOURCE[0]}")"; pwd -P)/standalone_backup_$(date "+%F-%H-%M-%S")
mkdir ${DATA_FOLDER}

if echo $(docker ps --format "{{.Names}}") | grep -q "${COMPOSE_PROJECT_NAME}_hhive_"; then
    DJANGO_CONTAINER_NAME="hhive"
else
    DJANGO_CONTAINER_NAME="server"
fi
echo -e "Будем использовать django контейнер ${DJANGO_CONTAINER_NAME}"

function save_postgres_data(){
  # Перечисляем БД для снятия бэкапа
  for db_label in main cache local
  do
    # Создаём команду для снятия бэкапа БД
    DUMP_COMMAND="PGPASSWORD=\$POSTGRES_${db_label^^}_PASSWORD pg_dump -O -x --clean --if-exists -h \$POSTGRES_${db_label^^}_HOST -p \$POSTGRES_${db_label^^}_PORT -d \$POSTGRES_${db_label^^}_NAME -U \$POSTGRES_${db_label^^}_USERNAME"

    echo -e "Делаем бэкап ${db_label}-базы в ${DATA_FOLDER}/${db_label}db.sql..."
    docker-compose -f $DOCKER_COMPOSE_DIRECTORY_PATH/docker-compose.standalone.yml exec ${DJANGO_CONTAINER_NAME} bash -c "${DUMP_COMMAND}" > ${DATA_FOLDER}/${db_label}db.sql

  done
}

function save_minio_data(){
  echo "Делаем бэкап minio-базы..."
  DUMP_COMMAND="mkdir -p /tmp/minio_backup/ && mc mirror --overwrite --remove local /tmp/minio_backup/"
  docker-compose -f ${DOCKER_COMPOSE_DIRECTORY_PATH}/docker-compose.standalone.yml exec minio bash -c "${DUMP_COMMAND}"

  echo -e "Копируем бэкап minio-базы в ${DATA_FOLDER}/minio_backup"
  MINIO_CONTAINER_NAME=$(docker ps --format "{{.Names}}" | grep "${COMPOSE_PROJECT_NAME}_minio")
  docker cp ${MINIO_CONTAINER_NAME}:/tmp/minio_backup ${DATA_FOLDER}/minio_backup

  echo "Удаляем бэкап minio-базы из контейнера"
  docker-compose -f ${DOCKER_COMPOSE_DIRECTORY_PATH}/docker-compose.standalone.yml exec minio rm -fR /tmp/minio_backup
}

function save_elasticsearch_data(){
  python3 elasticsearch_backup.py backup ${DATA_FOLDER} ${DOCKER_COMPOSE_DIRECTORY_PATH}
}

save_postgres_data
save_minio_data
save_elasticsearch_data
echo "Резервное копирование завершено"
exit $?