﻿/* <outputFile name="ChartTemplates.js" /> */

PP.ChartTemplates = function (settings)
{
	PP.ChartTemplates.base.constructor.apply(this, arguments);
	this._Interfaces = [];
};
PP.initClass(PP.ChartTemplates, PP.Object, 'PP.ChartTemplates', [PP.IPlugin]);
PP.Object.defineProps(PP.ChartTemplates, ['Interfaces', 'ImagePath'], false);

PP.ChartTemplates.prototype._ImagePath = PP.ImagePath;

PP.ChartTemplates.prototype.getInstance = function ()
{
	return null;
};

PP.ChartTemplates.init = function (settings)
{
	var t = new PP.ChartTemplates(settings);
	var templates = PP.Ui.getConfig().getChart().getTemplates();
	var newTemplates = {
		'building': {
			'Id': 'building',
			'PPType': 'PP.Ui.ChartColumnTemplate',
			'Source': t.getImagePath() + 'building.svg'
		},
		'circle': {
			'Id': 'circle',
			'PPType': 'PP.Ui.ChartColumnTemplate',
			'Source': t.getImagePath() + 'circle.svg'
		},
		'money': {
			'Id': 'money',
			'PPType': 'PP.Ui.ChartColumnTemplate',
			'Source': t.getImagePath() + 'money.svg'
		},
		'line': {
			'Id': 'line',
			'PPType': 'PP.Ui.ChartColumnTemplate',
			'Source': t.getImagePath() + 'line.svg'
		},
		'money2': {
			'Id': 'money2',
			'PPType': 'PP.Ui.ChartColumnTemplate',
			'Source': t.getImagePath() + 'money2.svg'
		},
		'human': {
			'Id': 'human',
			'PPType': 'PP.Ui.ChartPieTemplate',
			'Source': t.getImagePath() + 'human.svg'
		},
		'bag': {
			'Id': 'bag',
			'PPType': 'PP.Ui.ChartColumnTemplate',
			'Source': t.getImagePath() + 'bag.svg'
		}
	};

	for (var i = 0, nt; i < templates.length; i++)
	{
		if (nt = newTemplates[PP.getProperty(templates[i], 'Id')])
		{
			templates[i] = nt;
			delete newTemplates[nt.Id];
		}
	}
	for (var c in newTemplates)
		templates.push(newTemplates[c]);


	PP.Ui.getConfig().getChart().setTemplates(templates);
	return t;
};